/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.database.DatabaseTypes;
import com.mysql.cj.exceptions.CJCommunicationsException;
import com.mysql.cj.jdbc.exceptions.CommunicationsException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBConnection
implements AutoCloseable {
    private Connection connection = null;
    private boolean isConnectionValid;
    public static String HOST;
    public static String DATABASE;
    public static String USERNAME;
    public static String PASSWORD;
    public static DatabaseTypes DATABASE_TYPE;
    public static int PORT;
    public static boolean LOG_QUERIES;

    public DBConnection() {
        try {
            String connectionString;
            String driver;
            if (PORT == 0) {
                switch (DATABASE_TYPE) {
                    case MICROSOFT: {
                        PORT = 1433;
                        break;
                    }
                    default: {
                        PORT = 3306;
                    }
                }
            }
            switch (DATABASE_TYPE) {
                case MICROSOFT: {
                    driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                    connectionString = "jdbc:sqlserver://" + HOST + ":" + PORT + ";databaseName=" + DATABASE;
                    break;
                }
                default: {
                    driver = "com.mysql.cj.jdbc.Driver";
                    connectionString = "jdbc:mysql://" + HOST + ":" + PORT + "/" + DATABASE + "?serverTimezone=UTC";
                }
            }
            Class.forName(driver);
            DriverManager.setLoginTimeout(5);
            this.connection = DriverManager.getConnection(connectionString, USERNAME, PASSWORD);
            this.isConnectionValid = true;
        }
        catch (CJCommunicationsException | CommunicationsException e) {
            System.err.println("The connection to the database failed. Please check if the MySQL server is reachable and if you have an internet connection.");
            this.isConnectionValid = false;
            System.exit(1);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            this.isConnectionValid = false;
        }
    }

    public boolean isValid() {
        return this.isConnectionValid;
    }

    public ResultSet execute(String query) {
        try {
            Statement statement = this.connection.createStatement();
            ResultSet set = statement.executeQuery(query);
            statement.closeOnCompletion();
            return set;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ResultSet execute(String query, Object ... params) {
        try {
            PreparedStatement statement = this.connection.prepareStatement(query);
            for (int i = 0; i < params.length; ++i) {
                statement.setObject(i + 1, params[i]);
            }
            ResultSet set = statement.executeQuery();
            statement.closeOnCompletion();
            return set;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean update(String query) {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate(query);
            statement.closeOnCompletion();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean update(String query, Object ... params) {
        try {
            PreparedStatement statement = this.connection.prepareStatement(query);
            for (int i = 0; i < params.length; ++i) {
                statement.setObject(i + 1, params[i]);
            }
            statement.executeUpdate();
            statement.closeOnCompletion();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isOpen() {
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException e) {
            System.err.println("Could not determine connection status");
            this.isConnectionValid = false;
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            System.err.println("Could not close database connection");
        }
        finally {
            this.isConnectionValid = false;
        }
    }

    static {
        LOG_QUERIES = true;
    }
}

