/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.BinaryExpression;
import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SimpleExpressionVisitor
implements ExpressionVisitor<Expression> {
    protected static Expression stripQuotes(Expression e) {
        while (e.getExpressionType() == 32) {
            e = ((UnaryExpression)e).getFirst();
        }
        return e;
    }

    protected <T extends Expression> List<T> visitExpressionList(List<T> original) {
        if (original != null) {
            ArrayList<Expression> list = null;
            int n = original.size();
            for (int i = 0; i < n; ++i) {
                Expression p = ((Expression)original.get(i)).accept(this);
                if (list != null) {
                    list.add(p);
                    continue;
                }
                if (p == original.get(i)) continue;
                list = new ArrayList<Expression>(n);
                for (int j = 0; j < i; ++j) {
                    list.add((Expression)original.get(j));
                }
                list.add(p);
            }
            if (list != null) {
                return Collections.unmodifiableList(list);
            }
        }
        return original;
    }

    @Override
    public Expression visit(BinaryExpression e) {
        Expression visitedOp;
        Expression first = e.getFirst();
        Expression visitedFirst = first.accept(this);
        Expression second = e.getSecond();
        Expression visitedSecond = second.accept(this);
        Expression op = e.getOperator();
        Expression expression = visitedOp = op != null ? op.accept(this) : op;
        if (first != visitedFirst || second != visitedSecond || op != visitedOp) {
            return Expression.binary(e.getExpressionType(), visitedOp, visitedFirst, visitedSecond);
        }
        return e;
    }

    @Override
    public Expression visit(ConstantExpression e) {
        return e;
    }

    @Override
    public Expression visit(InvocationExpression e) {
        Expression expr = e.getTarget().accept(this);
        List<Expression> args = this.visitExpressionList(e.getArguments());
        if (args != e.getArguments() || expr != e.getTarget()) {
            return Expression.invoke((InvocableExpression)expr, args);
        }
        return e;
    }

    @Override
    public Expression visit(LambdaExpression<?> e) {
        Expression body = e.getBody().accept(this);
        if (body != e.getBody()) {
            return Expression.lambda(e.getResultType(), body, this.visitExpressionList(e.getParameters()));
        }
        return e;
    }

    @Override
    public Expression visit(MemberExpression e) {
        Expression instance = e.getInstance();
        if (instance != null && (instance = instance.accept(this)) != e.getInstance()) {
            return Expression.member(e.getExpressionType(), instance, e.getMember(), e.getResultType(), e.getParameters());
        }
        return e;
    }

    @Override
    public Expression visit(ParameterExpression e) {
        return e;
    }

    @Override
    public Expression visit(UnaryExpression e) {
        Expression visitedOp;
        Expression operand = e.getFirst();
        if (operand != (visitedOp = operand.accept(this))) {
            return Expression.unary(e.getExpressionType(), e.getResultType(), visitedOp);
        }
        return e;
    }
}

