/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.functions.Lambda2Sql;
import com.github.collinalpert.java2db.functions.SqlFunction;
import com.github.collinalpert.java2db.functions.SqlPredicate;
import com.github.collinalpert.java2db.mappers.BaseMapper;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Query<T extends BaseEntity> {
    private final BaseMapper<T> mapper;
    private final StringBuilder query;

    public Query(String tableName, BaseMapper<T> mapper) {
        this.mapper = mapper;
        this.query = new StringBuilder(String.format("select * from `%s`", tableName));
    }

    public Query(Query<T> subSelect, BaseMapper<T> mapper) {
        this.mapper = mapper;
        this.query = new StringBuilder(String.format("select * from (%s)", subSelect.getQuery()));
    }

    public Optional<T> getFirst() {
        Optional<T> optional;
        DBConnection connection = new DBConnection();
        Throwable throwable = null;
        try {
            Utilities.log(this.query.toString());
            optional = this.mapper.map(connection.execute(this.query.toString()));
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Query.$closeResource(throwable, connection);
                    throw throwable3;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        Query.$closeResource(throwable, connection);
        return optional;
    }

    public List<T> get() {
        List<T> list;
        DBConnection connection = new DBConnection();
        Throwable throwable = null;
        try {
            Utilities.log(this.query.toString());
            list = this.mapper.mapToList(connection.execute(this.query.toString()));
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Query.$closeResource(throwable, connection);
                    throw throwable3;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        Query.$closeResource(throwable, connection);
        return list;
    }

    public Query<T> as(String alias) {
        this.query.append(" as `").append(alias).append("`");
        return this;
    }

    public Query<T> where(SqlPredicate<T> predicate) {
        this.query.append(" where ").append(Lambda2Sql.toSql(predicate));
        return this;
    }

    public Query<T> orderBy(SqlFunction<T, ?> function) {
        return this.orderBy(function, OrderTypes.ASCENDING);
    }

    public Query<T> orderBy(SqlFunction<T, ?> function, OrderTypes type) {
        this.query.append(" order by `").append(Lambda2Sql.toSql(function)).append("` ").append(type.getSql());
        return this;
    }

    public Query<T> limit(int limit) {
        this.query.append(" limit ").append(limit);
        return this;
    }

    public String getQuery() {
        return this.query.toString();
    }

    public String toString() {
        return this.query.toString();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

