/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.utilities;

import com.github.collinalpert.java2db.annotations.ColumnName;
import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.annotations.Ignore;
import com.github.collinalpert.java2db.annotations.TableName;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.database.TableColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.exceptions.AsynchronousOperationException;
import com.github.collinalpert.java2db.utilities.ThrowableRunnable;
import com.github.collinalpert.java2db.utilities.ThrowableSupplier;
import com.github.collinalpert.java2db.utilities.UniqueIdentifier;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Utilities {
    public static List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass) {
        return Utilities.getEntityFields(instanceClass, null, false);
    }

    public static List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, boolean includeForeignKeys) {
        return Utilities.getEntityFields(instanceClass, null, includeForeignKeys);
    }

    public static List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, Class<?> delimiter) {
        return Utilities.getEntityFields(instanceClass, delimiter, false);
    }

    private static <T extends BaseEntity> List<Field> getEntityFields(Class<? super T> instanceClass, Class<?> delimiter, boolean includeForeignKeys) {
        LinkedList<Field> fields = new LinkedList<Field>();
        do {
            fields.addAll(Arrays.stream(instanceClass.getDeclaredFields()).filter(field -> field.getAnnotation(Ignore.class) == null && (includeForeignKeys || field.getAnnotation(ForeignKeyEntity.class) == null)).collect(Collectors.toList()));
        } while ((instanceClass = instanceClass.getSuperclass()) != delimiter);
        return fields;
    }

    public static List<TableColumnReference> getAllFields(Class<? extends BaseEntity> instanceClass) {
        return Utilities.getAllFields(instanceClass, "");
    }

    public static List<TableColumnReference> getAllFields(Class<? extends BaseEntity> instanceClass, String alias) {
        LinkedList<TableColumnReference> fields = new LinkedList<TableColumnReference>();
        for (Field field : Utilities.getEntityFields(instanceClass, true)) {
            if (field.getAnnotation(ForeignKeyEntity.class) != null) {
                String tempAlias = UniqueIdentifier.generate(Utilities.getTableName(field.getType()).substring(0, 1), field.getName());
                fields.add(new TableColumnReference(Utilities.getTableName(instanceClass), field, tempAlias, alias));
                fields.addAll(Utilities.getAllFields(field.getType(), tempAlias));
                continue;
            }
            fields.add(new TableColumnReference(Utilities.getTableName(instanceClass), field, alias, ""));
        }
        return fields;
    }

    public static void log(Object text) {
        if (DBConnection.LOG_QUERIES) {
            System.out.println(text);
        }
    }

    public static void logf(String text, Object ... params) {
        Utilities.log(String.format(text, params));
    }

    public static String getTableName(Class<?> type) {
        TableName tableNameAnnotation = type.getAnnotation(TableName.class);
        if (tableNameAnnotation == null) {
            return type.getSimpleName().toLowerCase();
        }
        return tableNameAnnotation.value();
    }

    public static String getColumnName(Field field) {
        ColumnName columnName = field.getAnnotation(ColumnName.class);
        if (columnName != null) {
            return columnName.value();
        }
        return field.getName();
    }

    public static <V> Supplier<V> supplierHandling(ThrowableSupplier<V, SQLException> supplier, Consumer<SQLException> exceptionHandling) {
        return () -> {
            try {
                return supplier.fetch();
            }
            catch (SQLException e) {
                if (exceptionHandling != null) {
                    exceptionHandling.accept(e);
                    return null;
                }
                throw new AsynchronousOperationException(e);
            }
        };
    }

    public static Runnable runnableHandling(ThrowableRunnable<SQLException> runnable, Consumer<SQLException> exceptionHandling) {
        return () -> {
            try {
                runnable.doAction();
            }
            catch (SQLException e) {
                if (exceptionHandling != null) {
                    exceptionHandling.accept(e);
                }
                throw new AsynchronousOperationException(e);
            }
        };
    }

    public static <E extends Throwable> void tryAction(ThrowableRunnable<E> runnable) {
        try {
            runnable.doAction();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

