/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.modules;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayModule<T> {
    private T[] data;
    private int chunkSize;
    private int counter;

    public ArrayModule(Class<T> clazz, int chunkSize) {
        this.data = (Object[])Array.newInstance(clazz, chunkSize);
        this.chunkSize = chunkSize;
    }

    public T[] getArray() {
        return this.trimArray(this.data);
    }

    public void addElement(T element) {
        if (this.data.length - 1 == this.counter) {
            this.data = Arrays.copyOf(this.data, this.data.length + this.chunkSize);
        }
        this.data[this.counter++] = element;
    }

    private T[] trimArray(T[] array) {
        int lastElement = 0;
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == null) continue;
            lastElement = i;
            break;
        }
        return Arrays.copyOf(array, lastElement + 1);
    }
}

