/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.transactions.Transaction;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionPool {
    private static final Map<String, Transaction> transactions;
    private static final DBConnection connection;

    public static DBConnection getConnection() {
        Optional transactionOptional = StackWalker.getInstance().walk(s -> s.limit(10L).map(x -> transactions.get(String.format("%s$%s", x.getClassName(), x.getMethodName()))).filter(Objects::nonNull).findFirst());
        if (transactionOptional.isEmpty()) {
            return connection;
        }
        return ((Transaction)transactionOptional.get()).getConnection();
    }

    public static void enlistTransaction(String transactionId, Transaction transaction) {
        transactions.put(transactionId, transaction);
    }

    public static void removeTransaction(String transactionId) {
        transactions.remove(transactionId);
    }

    static {
        connection = new DBConnection();
        transactions = new ConcurrentHashMap<String, Transaction>();
    }
}

