/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.transactions;

import com.github.collinalpert.java2db.database.ConnectionPool;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.exceptions.TransactionRolledBackException;
import com.github.collinalpert.java2db.transactions.Transaction;
import com.github.collinalpert.java2db.utilities.ThrowableConsumer;
import java.sql.Connection;
import java.util.Optional;

public class TransactionManager {
    public static void runTransaction(ThrowableConsumer<Transaction, Throwable> consumer) {
        TransactionManager.runTransaction(new DBConnection(), consumer);
    }

    public static void runTransaction(Connection connection, ThrowableConsumer<Transaction, Throwable> consumer) {
        TransactionManager.runTransaction(new DBConnection(connection), consumer);
    }

    public static void runTransaction(DBConnection connection, ThrowableConsumer<Transaction, Throwable> consumer) {
        Optional callingMethodOptional = StackWalker.getInstance().walk(s -> s.map(x -> String.format("%s$%s", x.getClassName(), x.getMethodName())).filter(x -> !x.equals("com.github.collinalpert.java2db.transactions.TransactionManager$runTransaction")).findFirst());
        if (callingMethodOptional.isEmpty()) {
            throw new RuntimeException("Transaction could not be created.");
        }
        String transactionId = (String)callingMethodOptional.get();
        Transaction transaction = new Transaction(connection);
        ConnectionPool.enlistTransaction(transactionId, transaction);
        try {
            consumer.consume(transaction);
            if (!transaction.isCommitted()) {
                transaction.commit();
            }
        }
        catch (Throwable e) {
            transaction.rollback();
            throw new TransactionRolledBackException("Exception was thrown. Transaction rolling back.", e);
        }
        finally {
            transaction.dispose();
            ConnectionPool.removeTransaction(transactionId);
        }
    }
}

