/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.function.math;

import com.trigersoft.jaque.function.math.UnaryOperator;
import java.math.BigDecimal;
import java.math.BigInteger;

public enum BinaryOperator {
    Add{

        @Override
        public Number eval(Number left, Number right) {
            if (left == null) {
                return right;
            }
            if (left instanceof Byte) {
                return (Byte)left + right.byteValue();
            }
            if (left instanceof Double) {
                return (Double)left + right.doubleValue();
            }
            if (left instanceof Float) {
                return Float.valueOf(((Float)left).floatValue() + right.floatValue());
            }
            if (left instanceof Integer) {
                return (Integer)left + right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left + right.longValue();
            }
            if (left instanceof Short) {
                return (Short)left + right.shortValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).add(BinaryOperator.getBigInteger(right));
            }
            if (left instanceof BigDecimal) {
                return ((BigDecimal)left).add(BinaryOperator.getBigDecimal(right));
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    And{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (Byte)left & right.byteValue();
            }
            if (left instanceof Integer) {
                return (Integer)left & right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left & right.longValue();
            }
            if (left instanceof Short) {
                return (Short)left & right.shortValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).and(BinaryOperator.getBigInteger(right));
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    Subtract{

        @Override
        public Number eval(Number left, Number right) {
            if (left == null) {
                return UnaryOperator.Negate.eval(right);
            }
            if (left instanceof Byte) {
                return (Byte)left - right.byteValue();
            }
            if (left instanceof Double) {
                return (Double)left - right.doubleValue();
            }
            if (left instanceof Float) {
                return Float.valueOf(((Float)left).floatValue() - right.floatValue());
            }
            if (left instanceof Integer) {
                return (Integer)left - right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left - right.longValue();
            }
            if (left instanceof Short) {
                return (Short)left - right.shortValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).subtract(BinaryOperator.getBigInteger(right));
            }
            if (left instanceof BigDecimal) {
                return ((BigDecimal)left).subtract(BinaryOperator.getBigDecimal(right));
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    Multiply{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (Byte)left * right.byteValue();
            }
            if (left instanceof Double) {
                return (Double)left * right.doubleValue();
            }
            if (left instanceof Float) {
                return Float.valueOf(((Float)left).floatValue() * right.floatValue());
            }
            if (left instanceof Integer) {
                return (Integer)left * right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left * right.longValue();
            }
            if (left instanceof Short) {
                return (Short)left * right.shortValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).multiply(BinaryOperator.getBigInteger(right));
            }
            if (left instanceof BigDecimal) {
                return ((BigDecimal)left).multiply(BinaryOperator.getBigDecimal(right));
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    Divide{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (double)((Byte)left).byteValue() / (double)right.byteValue();
            }
            if (left instanceof Double) {
                return (Double)left / right.doubleValue();
            }
            if (left instanceof Float) {
                return Float.valueOf(((Float)left).floatValue() / right.floatValue());
            }
            if (left instanceof Integer) {
                return (double)((Integer)left).intValue() / (double)right.intValue();
            }
            if (left instanceof Long) {
                return (double)((Long)left).longValue() / (double)right.longValue();
            }
            if (left instanceof Short) {
                return (double)((Short)left).shortValue() / (double)right.shortValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).divide(BinaryOperator.getBigInteger(right));
            }
            if (left instanceof BigDecimal) {
                return ((BigDecimal)left).divide(BinaryOperator.getBigDecimal(right));
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    Modulo{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (Byte)left % right.byteValue();
            }
            if (left instanceof Double) {
                return (Double)left % right.doubleValue();
            }
            if (left instanceof Float) {
                return Float.valueOf(((Float)left).floatValue() % right.floatValue());
            }
            if (left instanceof Integer) {
                return (Integer)left % right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left % right.longValue();
            }
            if (left instanceof Short) {
                return (Short)left % right.shortValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).mod(BinaryOperator.getBigInteger(right));
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    Or{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (Byte)left | right.byteValue();
            }
            if (left instanceof Integer) {
                return (Integer)left | right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left | right.longValue();
            }
            if (left instanceof Short) {
                return (Short)left | right.shortValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).or(BinaryOperator.getBigInteger(right));
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    Power{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (byte)Math.pow(left.doubleValue(), right.doubleValue());
            }
            if (left instanceof Double) {
                return Math.pow(left.doubleValue(), right.doubleValue());
            }
            if (left instanceof Float) {
                return Float.valueOf((float)Math.pow(left.doubleValue(), right.doubleValue()));
            }
            if (left instanceof Integer) {
                return (int)Math.pow(left.doubleValue(), right.doubleValue());
            }
            if (left instanceof Long) {
                return (long)Math.pow(left.doubleValue(), right.doubleValue());
            }
            if (left instanceof Short) {
                return (short)Math.pow(left.doubleValue(), right.doubleValue());
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).pow(right.intValue());
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    ShiftLeft{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (Byte)left << right.intValue();
            }
            if (left instanceof Integer) {
                return (Integer)left << right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left << right.intValue();
            }
            if (left instanceof Short) {
                return (Short)left << right.intValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).shiftLeft(right.intValue());
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    ShiftRight{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (Byte)left >> right.intValue();
            }
            if (left instanceof Integer) {
                return (Integer)left >> right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left >> right.intValue();
            }
            if (left instanceof Short) {
                return (Short)left >> right.intValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).shiftRight(right.intValue());
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    }
    ,
    Xor{

        @Override
        public Number eval(Number left, Number right) {
            if (left instanceof Byte) {
                return (Byte)left ^ right.byteValue();
            }
            if (left instanceof Integer) {
                return (Integer)left ^ right.intValue();
            }
            if (left instanceof Long) {
                return (Long)left ^ right.longValue();
            }
            if (left instanceof Short) {
                return (Short)left ^ right.shortValue();
            }
            if (left instanceof BigInteger) {
                return ((BigInteger)left).xor(BinaryOperator.getBigInteger(right));
            }
            throw new ArithmeticException(left.getClass().toString());
        }
    };


    public abstract Number eval(Number var1, Number var2);

    private static BigInteger getBigInteger(Number n) {
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }

    private static BigDecimal getBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return BigDecimal.valueOf(n.doubleValue());
    }
}

