/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.amqp;

import org.continuity.api.amqp.ExchangeBuilder;
import org.continuity.api.amqp.RoutingKeyFormatter;
import org.springframework.amqp.core.TopicExchange;

public class ExchangeDefinition<F extends RoutingKeyFormatter> {
    private static final String CONTINUITY_PREFIX = "continuity.";
    private final String name;
    private final boolean durable;
    private final boolean autoDelete;
    private final F routingKeyFormatter;

    protected ExchangeDefinition(String name, boolean durable, boolean autoDelete, F routingKeyFormatter) {
        this.name = name;
        this.durable = durable;
        this.autoDelete = autoDelete;
        this.routingKeyFormatter = routingKeyFormatter;
    }

    protected static ExchangeBuilder event(String scope, String event) {
        return new ExchangeBuilder("event." + scope + "." + event);
    }

    protected static ExchangeBuilder task(String scope, String task) {
        return new ExchangeBuilder("task." + scope + "." + task);
    }

    public String name() {
        return CONTINUITY_PREFIX + this.name;
    }

    public TopicExchange create() {
        return new TopicExchange(this.name(), this.durable, this.autoDelete);
    }

    public F formatRoutingKey() {
        return this.routingKeyFormatter;
    }

    public String deriveQueueName(String listeningService) {
        return CONTINUITY_PREFIX + listeningService + "." + this.name;
    }

    public String toString() {
        return this.name();
    }
}

