/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OrderGoal {
    CREATE_SESSION_LOGS,
    CREATE_WORKLOAD_MODEL,
    CREATE_LOAD_TEST,
    EXECUTE_LOAD_TEST;

    private static final Map<String, OrderGoal> prettyStringToGoal;

    @JsonCreator
    public static OrderGoal fromPrettyString(String key) {
        return prettyStringToGoal.get(key);
    }

    @JsonValue
    public String toPrettyString() {
        return this.name().replace("_", "-").toLowerCase();
    }

    static {
        prettyStringToGoal = new HashMap<String, OrderGoal>();
        for (OrderGoal goal : OrderGoal.values()) {
            prettyStringToGoal.put(goal.toPrettyString(), goal);
        }
    }
}

