/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OrderMode {
    PAST_SESSIONS,
    PAST_REQUESTS;

    private static final Map<String, OrderMode> prettyStringToMode;

    @JsonCreator
    public static OrderMode fromPrettyString(String key) {
        return prettyStringToMode.get(key);
    }

    @JsonValue
    public String toPrettyString() {
        return this.name().replace("_", "-").toLowerCase();
    }

    static {
        prettyStringToMode = new HashMap<String, OrderMode>();
        for (OrderMode mode : OrderMode.values()) {
            prettyStringToMode.put(mode.toPrettyString(), mode);
        }
    }
}

