/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CustomMapDeserializer
extends StdDeserializer<Map<String, String>> {
    private static final long serialVersionUID = 1L;

    public CustomMapDeserializer() {
        this(null);
    }

    public CustomMapDeserializer(Class<?> vc) {
        super(vc);
    }

    public Map<String, String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            return StreamSupport.stream(arrayNode.spliterator(), false).map(e -> new AbstractMap.SimpleEntry<String, String>(e.textValue(), "undefined")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(node.toString(), (TypeReference)new TypeReference<Map<String, String>>(){});
    }
}

