/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.links;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import org.continuity.api.entities.links.AbstractLinks;
import org.continuity.api.entities.links.IdpaLinks;
import org.continuity.api.entities.links.LoadTestLinks;
import org.continuity.api.entities.links.MeasurementDataLinks;
import org.continuity.api.entities.links.SessionLogsLinks;
import org.continuity.api.entities.links.WorkloadModelLinks;

public class LinkExchangeModel {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty(value="tag", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String tag;
    @JsonProperty(value="idpa", required=false)
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=AbstractLinks.ValueFilter.class)
    @JsonManagedReference
    private final IdpaLinks idpaLinks = new IdpaLinks(this);
    @JsonProperty(value="measurement-data", required=false)
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=AbstractLinks.ValueFilter.class)
    @JsonManagedReference
    private final MeasurementDataLinks measurementDataLinks = new MeasurementDataLinks(this);
    @JsonProperty(value="session-logs", required=false)
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=AbstractLinks.ValueFilter.class)
    @JsonManagedReference
    private final SessionLogsLinks sessionLogsLinks = new SessionLogsLinks(this);
    @JsonProperty(value="workload-model", required=false)
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=AbstractLinks.ValueFilter.class)
    @JsonManagedReference
    private final WorkloadModelLinks workloadModelLinks = new WorkloadModelLinks(this);
    @JsonProperty(value="load-test", required=false)
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=AbstractLinks.ValueFilter.class)
    @JsonManagedReference
    private final LoadTestLinks loadTestLinks = new LoadTestLinks(this);

    public String getTag() {
        return this.tag;
    }

    public LinkExchangeModel setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public IdpaLinks getIdpaLinks() {
        return this.idpaLinks;
    }

    public MeasurementDataLinks getMeasurementDataLinks() {
        return this.measurementDataLinks;
    }

    public SessionLogsLinks getSessionLogsLinks() {
        return this.sessionLogsLinks;
    }

    public WorkloadModelLinks getWorkloadModelLinks() {
        return this.workloadModelLinks;
    }

    public LoadTestLinks getLoadTestLinks() {
        return this.loadTestLinks;
    }

    public void merge(LinkExchangeModel other) {
        if (this.getTag() == null) {
            this.setTag(other.getTag());
        }
        for (Field field : LinkExchangeModel.class.getDeclaredFields()) {
            if (!AbstractLinks.class.isAssignableFrom(field.getType())) continue;
            try {
                this.mergeLinks(field, other);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private <T extends AbstractLinks<T>> void mergeLinks(Field field, LinkExchangeModel other) throws IllegalArgumentException, IllegalAccessException {
        ((AbstractLinks)field.get(this)).merge((AbstractLinks)field.get(other));
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return (Object)((Object)e) + " during serialization!";
        }
    }
}

