/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.continuity.api.entities.report.AbstractIdpaReport;
import org.continuity.api.entities.report.AnnotationViolation;
import org.continuity.api.entities.report.ApplicationChange;
import org.continuity.api.entities.report.ModelElementReference;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AnnotationValidityReport
extends AbstractIdpaReport {
    @JsonDeserialize(keyUsing=ModelElementReference.RefKeyDeserializer.class)
    private Map<ModelElementReference, Set<AnnotationViolation>> violations;
    @JsonProperty(value="violations-before-fix")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonDeserialize(keyUsing=ModelElementReference.RefKeyDeserializer.class)
    private Map<ModelElementReference, Set<AnnotationViolation>> violationsBeforeFix;

    public AnnotationValidityReport(Set<ApplicationChange> applicationChanges, Map<ModelElementReference, Set<AnnotationViolation>> violations) {
        super(applicationChanges);
        this.violations = violations;
    }

    public AnnotationValidityReport() {
    }

    public Map<ModelElementReference, Set<AnnotationViolation>> getViolations() {
        return this.violations;
    }

    public void setViolations(Map<ModelElementReference, Set<AnnotationViolation>> violations) {
        this.violations = violations;
    }

    public Map<ModelElementReference, Set<AnnotationViolation>> getViolationsBeforeFix() {
        return this.violationsBeforeFix;
    }

    public void setViolationsBeforeFix(Map<ModelElementReference, Set<AnnotationViolation>> violationsBeforeFix) {
        this.violationsBeforeFix = violationsBeforeFix;
    }

    @JsonIgnore
    public boolean isOk() {
        return this.getApplicationChanges().isEmpty() && this.violations.isEmpty();
    }

    @JsonIgnore
    public boolean isBreaking() {
        return this.violations.values().stream().flatMap(Collection::stream).reduce(false, (b, v) -> b != false || v.isBreaking(), Boolean::logicalOr);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return super.toString() + " [ERROR during serialization!]";
        }
    }

    public static AnnotationValidityReport empty() {
        return new AnnotationValidityReport(Collections.emptySet(), Collections.emptyMap());
    }
}

