/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.report;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.continuity.api.entities.report.ApplicationChangeType;
import org.continuity.api.entities.report.ModelElementReference;

public class ApplicationChange {
    @JsonProperty(value="message")
    private ApplicationChangeType type;
    @JsonProperty(value="changed-element")
    private ModelElementReference changedElement;
    @JsonProperty(value="changed-property")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String changedProperty;

    public ApplicationChange(ApplicationChangeType type, ModelElementReference referenced, String changedProperty) {
        this.type = type;
        this.changedElement = referenced;
        this.changedProperty = changedProperty;
    }

    public ApplicationChange(ApplicationChangeType type, ModelElementReference referenced) {
        this(type, referenced, null);
    }

    public ApplicationChange(ApplicationChangeType type) {
        this(type, null);
    }

    public ApplicationChange() {
    }

    public ApplicationChangeType getType() {
        return this.type;
    }

    public ModelElementReference getChangedElement() {
        return this.changedElement;
    }

    public void setChangedElement(ModelElementReference changedElement) {
        this.changedElement = changedElement;
    }

    public String getChangedProperty() {
        return this.changedProperty;
    }

    public void setChangedProperty(String changedProperty) {
        this.changedProperty = changedProperty;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.type);
        builder.append(":");
        builder.append(this.changedElement);
        if (this.changedProperty != null) {
            builder.append("(");
            builder.append(this.changedProperty);
            builder.append(")");
        }
        return builder.toString();
    }
}

