/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.report;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.continuity.api.entities.report.AbstractIdpaReport;
import org.continuity.api.entities.report.ApplicationChange;
import org.continuity.api.entities.report.ApplicationChangeType;
import org.continuity.api.entities.report.ModelElementReference;
import org.continuity.idpa.IdpaElement;
import org.continuity.idpa.application.Application;
import org.continuity.idpa.application.Endpoint;

public class ApplicationChangeReport
extends AbstractIdpaReport {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH-mm-ss-SSSX")
    private Date beforeChange;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH-mm-ss-SSSX")
    private Date afterChange;
    @JsonProperty(value="ignored-application-changes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<ApplicationChange> ignoredApplicationChanges;

    public ApplicationChangeReport(Set<ApplicationChange> changes, Date afterChange) {
        this(changes, Collections.emptySet(), new Date(0L), afterChange);
    }

    public ApplicationChangeReport(Set<ApplicationChange> changes, Date beforeChange, Date afterChange) {
        this(changes, Collections.emptySet(), beforeChange, afterChange);
    }

    public ApplicationChangeReport(Set<ApplicationChange> changes, Set<ApplicationChange> ignoredChanges, Date beforeChange, Date afterChange) {
        super(changes);
        this.ignoredApplicationChanges = ignoredChanges;
        this.beforeChange = beforeChange;
        this.afterChange = afterChange;
    }

    public ApplicationChangeReport() {
    }

    public static ApplicationChangeReport empty(Date afterChange) {
        return new ApplicationChangeReport(Collections.emptySet(), afterChange);
    }

    public static ApplicationChangeReport allOf(Application application) {
        HashSet<ApplicationChange> changes = new HashSet<ApplicationChange>();
        for (Endpoint interf : application.getEndpoints()) {
            changes.add(new ApplicationChange(ApplicationChangeType.ENDPOINT_ADDED, new ModelElementReference((IdpaElement)interf)));
        }
        return new ApplicationChangeReport(changes, application.getTimestamp());
    }

    public Set<ApplicationChange> getIgnoredApplicationChanges() {
        return this.ignoredApplicationChanges;
    }

    public void setIgnoredApplicationChanges(Set<ApplicationChange> ignoredSystemChanges) {
        this.ignoredApplicationChanges = ignoredSystemChanges;
    }

    public Date getBeforeChange() {
        return this.beforeChange;
    }

    public void setBeforeChange(Date beforeChange) {
        this.beforeChange = beforeChange;
    }

    public Date getAfterChange() {
        return this.afterChange;
    }

    public void setAfterChange(Date afterChange) {
        this.afterChange = afterChange;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return super.toString() + " [ERROR during serialization!]";
        }
    }
}

