/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.report;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import java.io.IOException;
import java.util.Objects;
import org.continuity.idpa.IdpaElement;
import org.continuity.idpa.WeakReference;

public class ModelElementReference {
    private static final String UNKNOWN_TYPE = "UNKNOWN";
    private String type;
    private String id;

    public ModelElementReference() {
    }

    public ModelElementReference(IdpaElement element) {
        this(element.getClass().getSimpleName(), element.getId());
    }

    public ModelElementReference(WeakReference<?> ref) {
        this(ref.getType() == null ? UNKNOWN_TYPE : ref.getType().getSimpleName(), ref.getId());
    }

    public ModelElementReference(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModelElementReference)) {
            return false;
        }
        ModelElementReference other = (ModelElementReference)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return this.id + " [" + this.type + "]";
    }

    public static class RefKeyDeserializer
    extends KeyDeserializer {
        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            if (key == null) {
                return null;
            }
            String id = null;
            String type = null;
            for (String element : key.split("\\,")) {
                if (element.startsWith("\"id\":")) {
                    id = element.substring(6, element.length() - 1);
                    continue;
                }
                if (!element.startsWith("\"type\":")) continue;
                type = element.substring(8, element.length() - 1);
            }
            return new ModelElementReference(type, id);
        }
    }
}

