/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.entities.report;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Set;
import org.continuity.api.entities.links.LinkExchangeModel;

@JsonPropertyOrder(value={"order-id", "number", "max", "testing-context", "successful", "error", "created-artifacts", "internal-artifacts"})
public class OrderReport {
    @JsonProperty(value="order-id")
    private String orderId;
    private int number;
    private int max;
    @JsonProperty(value="testing-context")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> testingContext;
    @JsonProperty(value="created-artifacts")
    private LinkExchangeModel createdArtifacts;
    @JsonProperty(value="internal-artifacts")
    private LinkExchangeModel internalArtifacts;
    private boolean successful;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String error;

    public OrderReport() {
    }

    public OrderReport(String orderId, Set<String> testingContext, LinkExchangeModel internalArtifacts, boolean successful, String error) {
        this.orderId = orderId;
        this.testingContext = testingContext;
        this.internalArtifacts = internalArtifacts;
        this.successful = successful;
        this.error = error;
    }

    public static OrderReport asSuccessful(String orderId, Set<String> testingContext, LinkExchangeModel internalArtifacts) {
        return new OrderReport(orderId, testingContext, internalArtifacts, true, null);
    }

    public static OrderReport asError(String orderId, LinkExchangeModel internalArtifacts, String error) {
        return new OrderReport(orderId, null, internalArtifacts, false, error);
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Set<String> getTestingContext() {
        return this.testingContext;
    }

    public void setTestingContext(Set<String> testingContext) {
        this.testingContext = testingContext;
    }

    public LinkExchangeModel getCreatedArtifacts() {
        return this.createdArtifacts;
    }

    public void setCreatedArtifacts(LinkExchangeModel createdArtifacts) {
        this.createdArtifacts = createdArtifacts;
    }

    public LinkExchangeModel getInternalArtifacts() {
        return this.internalArtifacts;
    }

    public void setInternalArtifacts(LinkExchangeModel internalArtifacts) {
        this.internalArtifacts = internalArtifacts;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

