/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.rest;

public class RequestBuilder {
    private String host;
    private final String path;
    private final StringBuilder queryString = new StringBuilder();
    private boolean queryStringEmpty = true;
    private boolean includeProtocol = true;

    public RequestBuilder(String host, String path) {
        this.host = host;
        this.path = path;
    }

    public String get() {
        String protocol = "";
        if (this.includeProtocol && !this.host.startsWith("http://") && !this.host.startsWith("https://")) {
            protocol = "http://";
        }
        return protocol + this.host + this.path + this.queryString;
    }

    public RequestBuilder withQuery(String param, String value) {
        if (this.queryStringEmpty) {
            this.queryString.append("?");
            this.queryStringEmpty = false;
        } else {
            this.queryString.append("&");
        }
        this.queryString.append(param);
        this.queryString.append("=");
        this.queryString.append(value);
        return this;
    }

    public RequestBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public String getURI() {
        return this.path + this.queryString;
    }

    public RequestBuilder withoutProtocol() {
        this.includeProtocol = false;
        return this;
    }

    public String toString() {
        return this.get();
    }
}

