/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.rest;

import java.util.HashMap;
import java.util.Map;
import org.continuity.api.rest.RestEndpoint;
import org.springframework.web.bind.annotation.RequestMethod;

public class RestApi {
    private RestApi() {
    }

    public static class Generic {
        public static final Map<String, RestEndpoint> WORKLOAD_MODEL_LINK = new HashMap<String, RestEndpoint>();
        public static final Map<String, RestEndpoint> PERSIST_WORKLOAD_MODEL = new HashMap<String, RestEndpoint>();
        public static final Map<String, RestEndpoint> GET_LOAD_TEST = new HashMap<String, RestEndpoint>();
        public static final Map<String, RestEndpoint> UPLOAD_LOAD_TEST = new HashMap<String, RestEndpoint>();
        public static final Map<String, RestEndpoint> GET_LOAD_TEST_REPORT = new HashMap<String, RestEndpoint>();
        public static final Map<String, RestEndpoint> DELETE_LOAD_TEST_REPORT = new HashMap<String, RestEndpoint>();

        private Generic() {
        }

        static {
            WORKLOAD_MODEL_LINK.put("wessbas", Wessbas.Model.OVERVIEW);
            WORKLOAD_MODEL_LINK.put("request-rates", RequestRates.Model.OVERVIEW);
            PERSIST_WORKLOAD_MODEL.put("wessbas", Wessbas.Model.PERSIST);
            GET_LOAD_TEST.put("jmeter", JMeter.TestPlan.GET);
            GET_LOAD_TEST.put("benchflow", BenchFlow.DSL.GET);
            UPLOAD_LOAD_TEST.put("jmeter", JMeter.TestPlan.POST);
            GET_LOAD_TEST_REPORT.put("jmeter", JMeter.Report.GET);
            GET_LOAD_TEST_REPORT.put("benchflow", BenchFlow.Report.GET);
            DELETE_LOAD_TEST_REPORT.put("jmeter", JMeter.Report.DELETE);
        }
    }

    public static class Wessbas {
        public static final String SERVICE_NAME = "wessbas";

        private Wessbas() {
        }

        public static class Model {
            public static final String ROOT = "/model";
            public static final RestEndpoint OVERVIEW = RestEndpoint.of("wessbas", "/model", "/{id}", RequestMethod.GET);
            public static final RestEndpoint REMOVE = RestEndpoint.of("wessbas", "/model", "/{id}", RequestMethod.DELETE);
            public static final RestEndpoint GET_APPLICATION = RestEndpoint.of("wessbas", "/model", "/{id}/application", RequestMethod.GET);
            public static final RestEndpoint GET_ANNOTATION = RestEndpoint.of("wessbas", "/model", "/{id}/annotation", RequestMethod.GET);
            public static final RestEndpoint PERSIST = RestEndpoint.of("wessbas", "/model", "/{id}/persist", RequestMethod.POST);

            private Model() {
            }

            public static class Paths {
                public static final String OVERVIEW = "/{id}";
                public static final String UPLOAD = "/{tag}";
                public static final String REMOVE = "/{id}";
                public static final String GET_APPLICATION = "/{id}/application";
                public static final String GET_ANNOTATION = "/{id}/annotation";
                public static final String PERSIST = "/{id}/persist";

                private Paths() {
                }
            }
        }

        public static class BehaviorModel {
            public static final String ROOT = "/behavior";
            public static final RestEndpoint CREATE = RestEndpoint.of("wessbas", "/behavior", "/{id}", RequestMethod.GET);

            private BehaviorModel() {
            }

            public static class Paths {
                public static final String CREATE = "/{id}";

                private Paths() {
                }
            }
        }

        public static class JMeter {
            public static final String ROOT = "/jmeter";
            public static final RestEndpoint CREATE = RestEndpoint.of("wessbas", "/jmeter", "/{id}", RequestMethod.GET);

            private JMeter() {
            }

            public static class Paths {
                public static final String CREATE = "/{id}";

                private Paths() {
                }
            }
        }
    }

    public static class SessionLogs {
        public static final String SERVICE_NAME = "session-logs";
        public static final String ROOT = "/sessions";
        public static final RestEndpoint GET = RestEndpoint.of("session-logs", "/sessions", "/{id}", RequestMethod.GET);

        private SessionLogs() {
        }

        public static class Paths {
            public static final String GET = "/{id}";

            private Paths() {
            }
        }
    }

    public static class RequestRates {
        public static final String SERVICE_NAME = "request-rates";

        private RequestRates() {
        }

        public static class RequestLogs {
            public static final String ROOT = "/requestlogs";
            public static final RestEndpoint GET = RestEndpoint.of("request-rates", "/requestlogs", "/{id}", RequestMethod.GET);
            public static final RestEndpoint UPLOAD = RestEndpoint.of("request-rates", "/requestlogs", "/", RequestMethod.POST);

            private RequestLogs() {
            }

            public static class Paths {
                public static final String GET = "/{id}";
                public static final String UPLOAD = "/";

                private Paths() {
                }
            }
        }

        public static class Model {
            public static final String ROOT = "/model";
            public static final RestEndpoint OVERVIEW = RestEndpoint.of("request-rates", "/model", "/{id}", RequestMethod.GET);
            public static final RestEndpoint GET_MODEL = RestEndpoint.of("request-rates", "/model", "/{id}/model", RequestMethod.GET);
            public static final RestEndpoint REMOVE = RestEndpoint.of("request-rates", "/model", "/{id}", RequestMethod.DELETE);
            public static final RestEndpoint GET_APPLICATION = RestEndpoint.of("request-rates", "/model", "/{id}/application", RequestMethod.GET);
            public static final RestEndpoint GET_ANNOTATION = RestEndpoint.of("request-rates", "/model", "/{id}/annotation", RequestMethod.GET);

            private Model() {
            }

            public static class Paths {
                public static final String OVERVIEW = "/{id}";
                public static final String GET_MODEL = "/{id}/model";
                public static final String REMOVE = "/{id}";
                public static final String GET_APPLICATION = "/{id}/application";
                public static final String GET_ANNOTATION = "/{id}/annotation";

                private Paths() {
                }
            }
        }

        public static class JMeter {
            public static final String ROOT = "/jmeter";
            public static final RestEndpoint CREATE = RestEndpoint.of("request-rates", "/jmeter", "/{id}", RequestMethod.GET);

            private JMeter() {
            }

            public static class Paths {
                public static final String CREATE = "/{id}";

                private Paths() {
                }
            }
        }
    }

    public static class BenchFlow {
        public static final String SERVICE_NAME = "benchflow";

        private BenchFlow() {
        }

        public static class Report {
            public static final String ROOT = "/report";
            public static final RestEndpoint GET = RestEndpoint.of("benchflow", "/report", "/{id}", RequestMethod.GET);
            public static final RestEndpoint DELETE = RestEndpoint.of("benchflow", "/report", "/{id}", RequestMethod.DELETE);

            private Report() {
            }

            public static class Paths {
                public static final String GET = "/{id}";
                public static final String DELETE = "/{id}";

                private Paths() {
                }
            }
        }

        public static class DSL {
            public static final String ROOT = "/loadtest";
            public static final RestEndpoint GET = RestEndpoint.of("benchflow", "/loadtest", "/{id}", RequestMethod.GET);

            private DSL() {
            }

            public static class Paths {
                public static final String GET = "/{id}";

                private Paths() {
                }
            }
        }
    }

    public static class JMeter {
        public static final String SERVICE_NAME = "jmeter";

        private JMeter() {
        }

        public static class Report {
            public static final String ROOT = "/report";
            public static final RestEndpoint GET = RestEndpoint.of("jmeter", "/report", "/{id}", RequestMethod.GET);
            public static final RestEndpoint DELETE = RestEndpoint.of("jmeter", "/report", "/{id}", RequestMethod.DELETE);

            private Report() {
            }

            public static class Paths {
                public static final String GET = "/{id}";
                public static final String DELETE = "/{id}";

                private Paths() {
                }
            }
        }

        public static class TestPlan {
            public static final String ROOT = "/loadtest";
            public static final RestEndpoint GET = RestEndpoint.of("jmeter", "/loadtest", "/{id}", RequestMethod.GET);
            public static final RestEndpoint POST = RestEndpoint.of("jmeter", "/loadtest", "/upload/{tag}", RequestMethod.POST);

            private TestPlan() {
            }

            public static class Paths {
                public static final String GET = "/{id}";
                public static final String POST = "/upload/{tag}";

                private Paths() {
                }
            }
        }
    }

    public static class IdpaApplication {
        public static final String SERVICE_NAME = "idpa-application";

        private IdpaApplication() {
        }

        public static class OpenApi {
            public static final String ROOT = "/openapi";
            public static final RestEndpoint UPDATE_FROM_JSON = RestEndpoint.of("idpa-application", "/openapi", "/{tag}/{version}/json", RequestMethod.POST);
            public static final RestEndpoint UPDATE_FROM_URL = RestEndpoint.of("idpa-application", "/openapi", "/{tag}/{version}/url", RequestMethod.POST);

            private OpenApi() {
            }

            public static class Paths {
                public static final String UPDATE_FROM_JSON = "/{tag}/{version}/json";
                public static final String UPDATE_FROM_URL = "/{tag}/{version}/url";

                private Paths() {
                }
            }
        }

        public static class Application {
            public static final String ROOT = "/application";
            public static final RestEndpoint GET = RestEndpoint.of("idpa-application", "/application", "/{tag}", RequestMethod.GET);
            public static final RestEndpoint GET_DELTA = RestEndpoint.of("idpa-application", "/application", "/{tag}/delta", RequestMethod.GET);
            public static final RestEndpoint UPDATE = RestEndpoint.of("idpa-application", "/application", "/{tag}", RequestMethod.POST);
            public static final RestEndpoint LEGACY_UPDATE = RestEndpoint.of("idpa-application", "/application", "/legacy/{tag}/update", RequestMethod.GET);

            private Application() {
            }

            public static class Paths {
                public static final String GET = "/{tag}";
                public static final String GET_DELTA = "/{tag}/delta";
                public static final String UPDATE = "/{tag}";
                public static final String LEGACY_UPDATE = "/legacy/{tag}/update";

                private Paths() {
                }
            }
        }
    }

    public static class IdpaAnnotation {
        public static final String SERVICE_NAME = "idpa-annotation";

        private IdpaAnnotation() {
        }

        public static class Dummy {
            public static final String ROOT = "/dummy/dvdstore";
            public static final RestEndpoint GET_APPLICATION = RestEndpoint.of("idpa-annotation", "/dummy/dvdstore", "/annotation", RequestMethod.GET);
            public static final RestEndpoint GET_ANNOTATION = RestEndpoint.of("idpa-annotation", "/dummy/dvdstore", "/application", RequestMethod.GET);

            private Dummy() {
            }

            public static class Paths {
                public static final String GET_APPLICATION = "/annotation";
                public static final String GET_ANNOTATION = "/application";

                private Paths() {
                }
            }
        }

        public static class Annotation {
            public static final String ROOT = "/annotation";
            public static final RestEndpoint GET = RestEndpoint.of("idpa-annotation", "/annotation", "/{tag}", RequestMethod.GET);
            public static final RestEndpoint GET_BASE = RestEndpoint.of("idpa-annotation", "/annotation", "/{tag}/base", RequestMethod.GET);
            public static final RestEndpoint UPDATE = RestEndpoint.of("idpa-annotation", "/annotation", "/{tag}", RequestMethod.POST);
            public static final RestEndpoint LEGACY_UPDATE = RestEndpoint.of("idpa-annotation", "/annotation", "/legacy/{tag}/update", RequestMethod.GET);

            private Annotation() {
            }

            public static class Paths {
                public static final String GET = "/{tag}";
                public static final String GET_BASE = "/{tag}/base";
                public static final String UPDATE = "/{tag}";
                public static final String UPLOAD = "/{tag}";
                public static final String LEGACY_UPDATE = "/legacy/{tag}/update";

                private Paths() {
                }
            }
        }
    }

    public static class Orchestrator {
        public static final String SERVICE_NAME = "orchestrator";

        private Orchestrator() {
        }

        public static class WorkloadModel {
            public static final String ROOT = "/workloadmodel";
            public static final RestEndpoint GET = RestEndpoint.of("orchestrator", "/workloadmodel", "/{type}/model/{id}", RequestMethod.GET);
            public static final RestEndpoint PERSIST = RestEndpoint.of("orchestrator", "/workloadmodel", "/{type}/model/{id}/persist", RequestMethod.POST);

            private WorkloadModel() {
            }

            public static class Paths {
                public static final String GET = "/{type}/model/{id}";
                public static final String PERSIST = "/{type}/model/{id}/persist";

                private Paths() {
                }
            }
        }

        public static class SessionLogs {
            public static final String ROOT = "/sessions";
            public static final RestEndpoint GET = RestEndpoint.of("orchestrator", "/sessions", "/{id}", RequestMethod.GET);

            private SessionLogs() {
            }

            public static class Paths {
                public static final String GET = "/{id}";

                private Paths() {
                }
            }
        }

        public static class Loadtest {
            public static final String ROOT = "/loadtest";
            public static final RestEndpoint GET = RestEndpoint.of("orchestrator", "/loadtest", "/{type}/test/{id}", RequestMethod.GET);
            public static final RestEndpoint REPORT = RestEndpoint.of("orchestrator", "/loadtest", "/{type}/report/{id}", RequestMethod.GET);
            public static final RestEndpoint DELETE_REPORT = RestEndpoint.of("orchestrator", "/loadtest", "/{type}/test/{id}", RequestMethod.DELETE);
            public static final RestEndpoint POST = RestEndpoint.of("orchestrator", "/loadtest", "/{type}/test/upload/{tag}", RequestMethod.POST);

            private Loadtest() {
            }

            public static class Paths {
                public static final String GET = "/{type}/test/{id}";
                public static final String REPORT = "/{type}/report/{id}";
                public static final String DELETE_REPORT = "/{type}/test/{id}";
                public static final String POST = "/{type}/test/upload/{tag}";

                private Paths() {
                }
            }
        }

        public static class Idpa {
            public static final String ROOT = "/idpa";
            public static final RestEndpoint GET_APPLICATION = RestEndpoint.of("orchestrator", "/idpa", "/{tag}/application", RequestMethod.GET);
            public static final RestEndpoint GET_ANNOTATION = RestEndpoint.of("orchestrator", "/idpa", "/{tag}/annotation", RequestMethod.GET);
            public static final RestEndpoint UPDATE_APPLICATION = RestEndpoint.of("orchestrator", "/idpa", "/{tag}/application", RequestMethod.POST);
            public static final RestEndpoint UPDATE_APP_FROM_OPEN_API_JSON = RestEndpoint.of("orchestrator", "/idpa", "/{tag}/openapi/{version}/json", RequestMethod.POST);
            public static final RestEndpoint UPDATE_APP_FROM_OPEN_API_URL = RestEndpoint.of("orchestrator", "/idpa", "/{tag}/openapi/{version}/url", RequestMethod.POST);
            public static final RestEndpoint UPDATE_ANNOTATION = RestEndpoint.of("orchestrator", "/idpa", "/{tag}/annotation", RequestMethod.POST);
            public static final RestEndpoint REPORT = RestEndpoint.of("orchestrator", "/idpa", "/report", RequestMethod.GET);

            private Idpa() {
            }

            public static class Paths {
                public static final String GET_APPLICATION = "/{tag}/application";
                public static final String GET_ANNOTATION = "/{tag}/annotation";
                public static final String UPDATE_APPLICATION = "/{tag}/application";
                public static final String UPDATE_APP_FROM_OPEN_API_JSON = "/{tag}/openapi/{version}/json";
                public static final String UPDATE_APP_FROM_OPEN_API_URL = "/{tag}/openapi/{version}/url";
                public static final String UPDATE_ANNOTATION = "/{tag}/annotation";
                public static final String REPORT = "/report";

                private Paths() {
                }
            }
        }

        public static class Orchestration {
            public static final String ROOT = "/order";
            public static final RestEndpoint RESULT = RestEndpoint.of("orchestrator", "/order", "/{id}/result", RequestMethod.GET);
            public static final RestEndpoint WAIT = RestEndpoint.of("orchestrator", "/order", "/{id}/wait", RequestMethod.GET);
            public static final RestEndpoint SUBMIT = RestEndpoint.of("orchestrator", "/order", "/submit", RequestMethod.GET);

            private Orchestration() {
            }

            public static class Paths {
                public static final String RESULT = "/{id}/result";
                public static final String WAIT = "/{id}/wait";
                public static final String SUBMIT = "/submit";

                private Paths() {
                }
            }
        }
    }
}

