/*
 * Decompiled with CFR 0.152.
 */
package org.continuity.api.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.continuity.api.rest.PathPar;
import org.continuity.api.rest.RequestBuilder;
import org.springframework.web.bind.annotation.RequestMethod;

public class RestEndpoint {
    private final String serviceName;
    private final String root;
    private final List<StringOrPar> elements;
    private final RequestMethod method;

    private RestEndpoint(String serviceName, String root, List<StringOrPar> elements, RequestMethod method) {
        this.serviceName = serviceName;
        this.root = root;
        this.elements = elements;
        this.method = method;
    }

    protected static RestEndpoint of(String serviceName, String root, String path, RequestMethod method) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pathElements = path.split("\\/");
        ArrayList<StringOrPar> elements = new ArrayList<StringOrPar>();
        for (String elem : pathElements) {
            if (elem.startsWith("{")) {
                elements.add(StringOrPar.of(PathPar.of(elem.substring(1, elem.length() - 1))));
                continue;
            }
            elements.add(StringOrPar.of(elem));
        }
        return new RestEndpoint(serviceName, root, elements, method);
    }

    public String genericPath() {
        return this.elements.stream().reduce(StringOrPar.of(this.root), StringOrPar::concat).toString();
    }

    public String path(Object ... values) {
        List<Object> valueList = Arrays.asList(values);
        Collections.reverse(valueList);
        Stack<Object> valueStack = new Stack<Object>();
        valueStack.addAll(valueList);
        return this.elements.stream().reduce(StringOrPar.of(this.root), (a, b) -> StringOrPar.concatWithValues(a, b, valueStack)).toString();
    }

    public RequestBuilder requestUrl(Object ... values) {
        return new RequestBuilder(this.serviceName, this.path(values));
    }

    public RequestMethod method() {
        return this.method;
    }

    public List<String> parsePathParameters(String link) {
        String[] linkElements = this.normalizeLink(link).split("\\/");
        if (linkElements.length != this.elements.size() + 2) {
            return null;
        }
        if (!this.root.equals(linkElements[1]) && !this.root.equals("/" + linkElements[1])) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        int i = 2;
        for (StringOrPar stringOrPar : this.elements) {
            if (stringOrPar.isPar()) {
                params.add(linkElements[i]);
            } else if (!stringOrPar.toString().equals(linkElements[i])) {
                return null;
            }
            ++i;
        }
        return params;
    }

    private String normalizeLink(String link) {
        if (link.startsWith("http://")) {
            link = link.substring(7);
        } else if (link.startsWith("https://")) {
            link = link.substring(8);
        }
        if (link.startsWith("/")) {
            link = link.substring(1);
        }
        if (link.endsWith("/")) {
            link = link.substring(0, link.length() - 1);
        }
        return link;
    }

    public static class StringOrPar {
        private final String string;
        private final PathPar par;

        private StringOrPar(String string, PathPar par) {
            this.string = string;
            this.par = par;
        }

        public static StringOrPar of(String string) {
            return new StringOrPar(string, null);
        }

        public static StringOrPar of(PathPar par) {
            return new StringOrPar(null, par);
        }

        public static StringOrPar concat(StringOrPar first, StringOrPar second) {
            if ("/".equals(second.toString()) || "".equals(second.toString())) {
                return first;
            }
            return StringOrPar.of(first + "/" + second);
        }

        public static StringOrPar concatWithValues(StringOrPar first, StringOrPar second, Stack<Object> values) {
            if ("/".equals(second.toString()) || "".equals(second.toString())) {
                return first;
            }
            if (second.isPar()) {
                return StringOrPar.of(first + "/" + values.pop());
            }
            return StringOrPar.of(first + "/" + second);
        }

        public boolean isString() {
            return this.string != null;
        }

        public boolean isPar() {
            return this.par != null;
        }

        public String toString() {
            if (this.isPar()) {
                return this.par.generic();
            }
            return this.string;
        }
    }
}

