/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import com.github.javaparser.JavaParser;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import configuration.FreeMarkerConfiguration;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import initialization.InitializationService;
import java.io.File;
import java.io.IOException;
import merger.CodeSnipitMerger;
import merger.LineMerger;
import reader.ClassContainerReader;

public class StaticJavaForgerConfiguration {
    private ClassContainerReader reader = new ClassContainerReader();
    private InitializationService initializer = new InitializationService();
    private CodeSnipitMerger merger = new LineMerger();
    private Configuration freeMarkerConfiguration = FreeMarkerConfiguration.getDefaultConfig();
    private JavaSymbolSolver symbolSolver;
    private static final StaticJavaForgerConfiguration config = new StaticJavaForgerConfiguration();

    private StaticJavaForgerConfiguration() {
    }

    public static StaticJavaForgerConfiguration getConfig() {
        return config;
    }

    public static ClassContainerReader getReader() {
        return StaticJavaForgerConfiguration.getConfig().reader;
    }

    public void setReader(ClassContainerReader classReader) {
        StaticJavaForgerConfiguration.config.reader = classReader;
    }

    public static InitializationService getInitializer() {
        return StaticJavaForgerConfiguration.getConfig().initializer;
    }

    public void setInitializer(InitializationService initializer) {
        StaticJavaForgerConfiguration.config.initializer = initializer;
    }

    public static void reset() {
        StaticJavaForgerConfiguration conf = StaticJavaForgerConfiguration.getConfig();
        conf.setReader(new ClassContainerReader());
        conf.setMerger(new LineMerger());
        conf.setFreeMarkerConfiguration(FreeMarkerConfiguration.getDefaultConfig());
    }

    public static CodeSnipitMerger getMerger() {
        return StaticJavaForgerConfiguration.getConfig().merger;
    }

    public void setMerger(CodeSnipitMerger merger) {
        StaticJavaForgerConfiguration.config.merger = merger;
    }

    public Configuration getFreeMarkerConfiguration() {
        return this.freeMarkerConfiguration;
    }

    public void setFreeMarkerConfiguration(Configuration freeMarkerConfig) {
        this.freeMarkerConfiguration = freeMarkerConfig;
    }

    public void addTemplateLocation(String templateLocation) throws IOException {
        FileTemplateLoader loader = new FileTemplateLoader(new File(templateLocation));
        TemplateLoader original = this.getFreeMarkerConfiguration().getTemplateLoader();
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{original, loader});
        this.freeMarkerConfiguration.setTemplateLoader((TemplateLoader)mtl);
    }

    public void setSymbolSolver(JavaSymbolSolver symbolSolver) {
        this.symbolSolver = symbolSolver;
        JavaParser.getStaticConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
    }

    public JavaSymbolSolver getSymbolSolver() {
        return this.symbolSolver;
    }
}

