/*
 * Decompiled with CFR 0.152.
 */
package merger;

import configuration.JavaForgerConfiguration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import merger.CodeSnipitLocation;

public class CodeSnipitInserter {
    public void insert(JavaForgerConfiguration config, String mergeClassPath, String newCode, LinkedHashMap<CodeSnipitLocation, CodeSnipitLocation> newCodeInsertionLocations) throws IOException {
        List<String> existingLines = Files.readAllLines(Paths.get(mergeClassPath, new String[0]), StandardCharsets.UTF_8);
        List<String> newlines = Arrays.asList(newCode.split("\\r?\\n"));
        List<String> result = this.insert(config, existingLines, newlines, newCodeInsertionLocations);
        Files.write(Paths.get(mergeClassPath, new String[0]), result, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private List<String> insert(JavaForgerConfiguration config, List<String> existingLines, List<String> newlines, LinkedHashMap<CodeSnipitLocation, CodeSnipitLocation> newCodeInsertionLocations) {
        int addedLines = 0;
        for (Map.Entry<CodeSnipitLocation, CodeSnipitLocation> locations : newCodeInsertionLocations.entrySet()) {
            CodeSnipitLocation codeLocation = locations.getKey();
            CodeSnipitLocation insertLocation = locations.getValue();
            if (!config.isOverride() && insertLocation.containsLines()) continue;
            int i = insertLocation.getFirstIndex();
            while (i < insertLocation.getLastIndex()) {
                existingLines.remove(addedLines + insertLocation.getFirstIndex());
                ++i;
            }
            i = 0;
            while (i < codeLocation.size()) {
                existingLines.add(addedLines + insertLocation.getFirstIndex() + i, newlines.get(codeLocation.getFirstIndex() + i));
                ++i;
            }
            addedLines += codeLocation.size() - insertLocation.size();
        }
        return existingLines;
    }
}

