/*
 * Decompiled with CFR 0.152.
 */
package merger;

import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.nodeTypes.modifiers.NodeWithAccessModifiers;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class NodeComparator
implements Comparator<Node> {
    public boolean nodeTypeIsSupported(Node node) {
        return Arrays.asList(PackageDeclaration.class, ImportDeclaration.class, ClassOrInterfaceDeclaration.class, BodyDeclaration.class, FieldDeclaration.class).stream().anyMatch(claz -> claz.isAssignableFrom(node.getClass()));
    }

    @Override
    public int compare(Node a, Node b) {
        Integer compare = this.nodeTypeIsSupported(a) && this.nodeTypeIsSupported(b) ? null : Integer.valueOf(-1);
        compare = compare != null ? compare : this.comparePackage(a, b);
        compare = compare != null ? compare : this.compareImport(a, b);
        compare = compare != null ? compare : this.compareField(a, b);
        compare = compare != null ? compare : this.compareConstructor(a, b);
        compare = compare != null ? compare : this.compareMethod(a, b);
        compare = compare != null ? compare : this.compareClass(a, b);
        return compare == null ? -1 : compare;
    }

    private Integer comparePackage(Node a, Node b) {
        Integer compare = a instanceof PackageDeclaration ? Integer.valueOf(b instanceof PackageDeclaration ? 0 : -1) : (b instanceof PackageDeclaration ? Integer.valueOf(1) : null);
        return compare;
    }

    private Integer compareImport(Node a, Node b) {
        Integer compare = a instanceof ImportDeclaration ? Integer.valueOf(-1) : (b instanceof ImportDeclaration ? Integer.valueOf(1) : null);
        return compare;
    }

    private Integer compareField(Node a, Node b) {
        BiFunction<Node, Node, Boolean> equals = (x, y) -> ((FieldDeclaration)x).getVariable(0).getNameAsString().equals(((FieldDeclaration)y).getVariable(0).getNameAsString());
        return this.compareNode(a, b, FieldDeclaration.class, equals);
    }

    private Integer compareConstructor(Node a, Node b) {
        return this.compareNode(a, b, ConstructorDeclaration.class, this::isBodyDeclarationEqual);
    }

    private Integer compareMethod(Node a, Node b) {
        return this.compareNode(a, b, MethodDeclaration.class, this::isBodyDeclarationEqual);
    }

    private Integer compareClass(Node a, Node b) {
        BiFunction<Node, Node, Boolean> equals = (x, y) -> ((ClassOrInterfaceDeclaration)x).getNameAsString().equals(((ClassOrInterfaceDeclaration)y).getNameAsString());
        return this.compareNode(a, b, ClassOrInterfaceDeclaration.class, equals);
    }

    private Boolean isBodyDeclarationEqual(Node a, Node b) {
        boolean isReplacement = false;
        CallableDeclaration m1 = (CallableDeclaration)a;
        CallableDeclaration m2 = (CallableDeclaration)b;
        isReplacement = m1.getName().equals((Object)m2.getName());
        List parameterTypes1 = m1.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
        List parameterTypes2 = m2.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
        isReplacement = isReplacement && parameterTypes1.equals(parameterTypes2);
        return isReplacement;
    }

    private Integer compareNode(Node a, Node b, Class<?> claz, BiFunction<Node, Node, Boolean> equals) {
        Integer compare = claz.isAssignableFrom(a.getClass()) && claz.isAssignableFrom(b.getClass()) ? (equals.apply(a, b).booleanValue() ? Integer.valueOf(0) : this.compareModifiers(a, b)) : (claz.isAssignableFrom(a.getClass()) ? Integer.valueOf(-1) : (claz.isAssignableFrom(b.getClass()) ? Integer.valueOf(1) : null));
        return compare;
    }

    private Integer compareModifiers(Node a, Node b) {
        Integer compare = null;
        if (NodeWithAccessModifiers.class.isAssignableFrom(a.getClass()) && NodeWithAccessModifiers.class.isAssignableFrom(b.getClass())) {
            EnumSet modA = ((NodeWithAccessModifiers)a).getModifiers();
            EnumSet modB = ((NodeWithAccessModifiers)b).getModifiers();
            compare = modA.contains(Modifier.PUBLIC) ? Integer.valueOf(-1) : (modA.contains(Modifier.PROTECTED) ? Integer.valueOf(!modB.contains(Modifier.PUBLIC) && !this.isDefaultModifier(modB) ? -1 : 1) : (modA.contains(Modifier.PRIVATE) ? Integer.valueOf(modB.contains(Modifier.PRIVATE) ? -1 : 1) : Integer.valueOf(!modB.contains(Modifier.PUBLIC) ? -1 : 1)));
        }
        return compare;
    }

    private boolean isDefaultModifier(EnumSet<Modifier> modifiers) {
        return !modifiers.contains(Modifier.PUBLIC) && !modifiers.contains(Modifier.PROTECTED) && !modifiers.contains(Modifier.PRIVATE);
    }
}

