/*
 * Decompiled with CFR 0.152.
 */
package reader;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import configuration.StaticJavaForgerConfiguration;
import generator.JavaForgerException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import templateInput.ClassContainer;
import templateInput.definition.ClassDefinition;
import templateInput.definition.MethodDefinition;
import templateInput.definition.TypeDefinition;
import templateInput.definition.VariableDefinition;

public class ClassContainerReader {
    private StaticJavaForgerConfiguration staticConfig = StaticJavaForgerConfiguration.getConfig();

    public ClassContainer read(String inputClass) throws IOException {
        CompilationUnit cu = this.getCompilationUnit(inputClass);
        return this.readCompilationUnit(cu);
    }

    private CompilationUnit getCompilationUnit(String inputClass) throws IOException {
        CompilationUnit cu = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream in = new FileInputStream(inputClass);){
                cu = JavaParser.parse((InputStream)in);
                in.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new JavaForgerException(e, "Could not parse " + inputClass);
        }
        return cu;
    }

    private ClassContainer readCompilationUnit(CompilationUnit cu) {
        ClassContainer claz = new ClassContainer();
        ArrayList<VariableDefinition> fields = new ArrayList<VariableDefinition>();
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        ArrayList<MethodDefinition> constructors = new ArrayList<MethodDefinition>();
        for (TypeDeclaration type : cu.getTypes()) {
            if (type instanceof ClassOrInterfaceDeclaration) {
                claz = this.parseClass(type);
            }
            List childNodes = type.getChildNodes();
            for (Node node : childNodes) {
                if (node instanceof FieldDeclaration) {
                    fields.add(this.parseField(node));
                    continue;
                }
                if (node instanceof MethodDeclaration) {
                    methods.add(this.parseMethod(node));
                    continue;
                }
                if (!(node instanceof ConstructorDeclaration)) continue;
                constructors.add(this.parseConstructor(node));
            }
        }
        Optional<String> typeImport = cu.getPackageDeclaration().map(pd -> pd.getNameAsString());
        if (typeImport.isPresent()) {
            claz.addTypeImport(String.valueOf(typeImport.get()) + "." + claz.getName());
            constructors.forEach(c -> c.addTypeImport((String)typeImport.get()));
        }
        claz.setFields(fields);
        claz.setMethods(methods);
        claz.setConstructors(constructors);
        return claz;
    }

    private ClassContainer parseClass(TypeDeclaration<?> type) {
        ClassOrInterfaceDeclaration cd = (ClassOrInterfaceDeclaration)type;
        Set<String> annotations = cd.getAnnotations().stream().map(annotation -> annotation.getName().toString()).collect(Collectors.toSet());
        Set<String> accessModifiers = cd.getModifiers().stream().map(modifier -> modifier.asString()).collect(Collectors.toSet());
        List<String> interfaces = cd.getImplementedTypes().stream().map(i -> i.getNameAsString()).collect(Collectors.toList());
        String extend = cd.getExtendedTypes().stream().findFirst().map(e -> e.getNameAsString()).orElse(null);
        ClassDefinition def = ClassDefinition.builder().withName(cd.getNameAsString()).withType(cd.getNameAsString()).withLineNumber(cd.getBegin().map(p -> p.line).orElse(-1)).withColumn(cd.getBegin().map(p -> p.column).orElse(-1)).withAnnotations(annotations).withAccessModifiers(accessModifiers).withExtend(extend).withInterfaces(interfaces).build();
        return new ClassContainer(def);
    }

    private MethodDefinition parseMethod(Node node) {
        MethodDeclaration md = (MethodDeclaration)node;
        MethodDefinition method = this.parseCallable((CallableDeclaration<?>)md);
        method.setType(md.getTypeAsString());
        this.resolveAndSetImport(md.getType(), method);
        return method;
    }

    private MethodDefinition parseConstructor(Node node) {
        ConstructorDeclaration md = (ConstructorDeclaration)node;
        MethodDefinition method = this.parseCallable((CallableDeclaration<?>)md);
        method.setType(md.getNameAsString());
        return method;
    }

    private MethodDefinition parseCallable(CallableDeclaration<?> md) {
        Set<String> accessModifiers = md.getModifiers().stream().map(Modifier::asString).collect(Collectors.toSet());
        Set<String> annotations = md.getAnnotations().stream().map(NodeWithName::getNameAsString).collect(Collectors.toSet());
        return ((MethodDefinition.Builder)((MethodDefinition.Builder)((MethodDefinition.Builder)((MethodDefinition.Builder)((MethodDefinition.Builder)MethodDefinition.builder().withName(md.getNameAsString())).withAccessModifiers(accessModifiers)).withAnnotations(annotations)).withLineNumber(md.getBegin().map(p -> p.line).orElse(-1))).withColumn(md.getBegin().map(p -> p.column).orElse(-1))).withParameters(this.getParameters(md)).build();
    }

    private VariableDefinition parseField(Node node) {
        FieldDeclaration fd = (FieldDeclaration)node;
        Set<String> annotations = fd.getAnnotations().stream().map(annotation -> annotation.getName().toString()).collect(Collectors.toSet());
        Set<String> accessModifiers = fd.getModifiers().stream().map(modifier -> modifier.asString()).collect(Collectors.toSet());
        Optional<String> originalInit = this.depthFirstSearch((Node)fd, Expression.class);
        VariableDefinition variable = ((VariableDefinition.Builder)((VariableDefinition.Builder)((VariableDefinition.Builder)((VariableDefinition.Builder)((VariableDefinition.Builder)((VariableDefinition.Builder)VariableDefinition.builder().withName(fd.getVariable(0).getName().asString())).withType(fd.getElementType().asString())).withAnnotations(annotations)).withLineNumber(fd.getBegin().map(p -> p.line).orElse(-1))).withColumn(fd.getBegin().map(p -> p.column).orElse(-1))).withAccessModifiers(accessModifiers)).originalInit(originalInit.orElse(null)).build();
        this.resolveAndSetImport(fd.getElementType(), variable);
        return variable;
    }

    private Optional<String> depthFirstSearch(Node node, Class<Expression> claz) {
        if (claz.isAssignableFrom(node.getClass())) {
            return Optional.of(node.toString());
        }
        return node.getChildNodes().stream().map(n -> this.depthFirstSearch((Node)n, claz)).filter(Optional::isPresent).map(Optional::get).map(Object::toString).findFirst();
    }

    private List<VariableDefinition> getParameters(CallableDeclaration<?> md) {
        LinkedHashMap params = new LinkedHashMap();
        md.getParameters().stream().forEach(p -> {
            VariableDefinition variableDefinition = params.put(p, ((VariableDefinition.Builder)((VariableDefinition.Builder)VariableDefinition.builder().withName(p.getNameAsString())).withType(p.getTypeAsString())).build());
        });
        params.entrySet().forEach(p -> this.resolveAndSetImport(((Parameter)p.getKey()).getType(), (TypeDefinition)p.getValue()));
        List<VariableDefinition> parameters = params.values().stream().collect(Collectors.toList());
        return parameters;
    }

    private void resolveAndSetImport(Type type, TypeDefinition variable) {
        List<String> imports = this.resolve(type);
        if (!imports.isEmpty()) {
            imports.stream().filter(s -> !s.contains("?")).forEach(s -> variable.addTypeImport((String)s));
        }
    }

    private List<String> resolve(Type type) {
        ArrayList<String> imports = new ArrayList<String>();
        if (this.staticConfig.getSymbolSolver() != null) {
            try {
                ResolvedType resolve = type.resolve();
                imports.addAll(this.getImportsFromResolvedType(resolve));
            }
            catch (Exception e) {
                System.err.println("FieldReader: Could not resolve import for " + type.asString());
            }
        }
        return imports;
    }

    private List<String> getImportsFromResolvedType(ResolvedType resolve) {
        String imp;
        ArrayList<String> imports = new ArrayList<String>();
        if (resolve.isReferenceType()) {
            ResolvedReferenceType refType = resolve.asReferenceType();
            ResolvedReferenceTypeDeclaration type = refType.getTypeDeclaration();
            imp = type.getQualifiedName();
            List innerResolvedTypes = type.getTypeParameters().stream().map(tp -> refType.typeParametersMap().getValue(tp)).collect(Collectors.toList());
            List collect = innerResolvedTypes.stream().flatMap(t -> this.getImportsFromResolvedType((ResolvedType)t).stream()).collect(Collectors.toList());
            imports.addAll(collect);
        } else {
            imp = resolve.describe();
        }
        if (!imp.startsWith("java.lang.") && !resolve.isPrimitive()) {
            imports.add(imp);
        }
        return imports;
    }
}

