/*
 * Decompiled with CFR 0.152.
 */
package merger;

import configuration.JavaForgerConfiguration;
import generator.CodeSnipit;
import generator.JavaForgerException;
import java.io.File;
import java.io.IOException;

public abstract class CodeSnipitMerger {
    public void merge(JavaForgerConfiguration config, CodeSnipit codeSnipit, String mergeClassPath) throws IOException {
        if (this.validate(codeSnipit, mergeClassPath)) {
            this.executeMerge(config, codeSnipit, mergeClassPath);
            this.format(config, mergeClassPath);
        }
    }

    protected abstract void executeMerge(JavaForgerConfiguration var1, CodeSnipit var2, String var3) throws IOException;

    protected boolean validate(CodeSnipit codeSnipit, String mergeClassPath) {
        boolean success = true;
        if (mergeClassPath == null) {
            throw new JavaForgerException("merge class path may not be null");
        }
        if (mergeClassPath.isEmpty()) {
            throw new JavaForgerException("merge class path may not be empty");
        }
        if (!new File(mergeClassPath).exists()) {
            throw new JavaForgerException("merge class path does not point to existing file: " + mergeClassPath);
        }
        if (codeSnipit.getCode().isEmpty()) {
            System.err.println("CodeSnipit is empty and cannot be merged to: " + mergeClassPath);
            success = false;
        }
        return success;
    }

    protected void format(JavaForgerConfiguration config, String mergeClassPath) {
        System.err.println("formatting is not yet supported and should be done manually for class " + mergeClassPath);
    }
}

