/*
 * Decompiled with CFR 0.152.
 */
package merger;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import configuration.JavaForgerConfiguration;
import generator.CodeSnipit;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import merger.CodeSnipitMerger;
import merger.CodeSnipitReader;

public class JavaParserMerger
extends CodeSnipitMerger {
    private CodeSnipitReader reader = new CodeSnipitReader();

    @Override
    protected void executeMerge(JavaForgerConfiguration config, CodeSnipit codeSnipit, String mergeClassPath) throws IOException {
        CompilationUnit existingCode = this.reader.read(mergeClassPath);
        String completeClass = this.reader.toCompleteClass(codeSnipit, mergeClassPath);
        CompilationUnit newCode = this.reader.readClass(completeClass);
        this.merge(existingCode, newCode);
        this.write(mergeClassPath, existingCode);
    }

    private void merge(CompilationUnit existingCode, CompilationUnit newCode) {
        this.mergeImports(existingCode, newCode);
        NodeList existingMembers = this.getParent(existingCode).getMembers();
        NodeList newMembers = this.getParent(newCode).getMembers();
        for (BodyDeclaration member : newMembers) {
            int replacementIndex = this.findReplacementNode(existingMembers, member);
            if (replacementIndex >= 0) {
                existingMembers.set(replacementIndex, (Node)member);
                continue;
            }
            int insertIndex = this.findInsertionLocation(existingMembers, member);
            existingMembers.add(insertIndex, (Node)member);
        }
    }

    private void mergeImports(CompilationUnit existingCode, CompilationUnit newCode) {
        HashSet existingSet = new HashSet(existingCode.getImports());
        newCode.getImports().stream().filter(imp -> !existingSet.contains(imp)).forEach(t -> {
            existingCode.addImport(t);
            existingSet.add(t);
        });
    }

    private int findInsertionLocation(NodeList<BodyDeclaration<?>> existingMembers, BodyDeclaration<?> member) {
        int index = 0;
        for (int i = 0; i < existingMembers.size(); ++i) {
            if (!((BodyDeclaration)existingMembers.get(i)).getClass().equals(member.getClass())) continue;
            Optional<NodeList<Modifier>> modNew = this.findModifiers(member);
            Optional<NodeList<Modifier>> modExist = this.findModifiers((BodyDeclaration)existingMembers.get(i));
            if (modNew.isPresent() && modExist.isPresent()) {
                if (!this.hasHigherPriorityModifier(modExist.get(), modNew.get())) continue;
                index = i + 1;
                continue;
            }
            index = i + 1;
        }
        return index;
    }

    private boolean hasHigherPriorityModifier(NodeList<Modifier> modExist, NodeList<Modifier> modNew) {
        boolean hasHigherPrio = modExist.contains((Node)Modifier.publicModifier()) ? true : (modExist.contains((Node)Modifier.protectedModifier()) ? !modNew.contains((Node)Modifier.publicModifier()) && !this.isDefaultModifier(modNew) : (modExist.contains((Node)Modifier.privateModifier()) ? modNew.contains((Node)Modifier.privateModifier()) : !modNew.contains((Node)Modifier.publicModifier())));
        return hasHigherPrio;
    }

    private boolean isDefaultModifier(NodeList<Modifier> modifiers) {
        return !modifiers.contains((Node)Modifier.publicModifier()) && !modifiers.contains((Node)Modifier.protectedModifier()) && !modifiers.contains((Node)Modifier.privateModifier());
    }

    private Optional<NodeList<Modifier>> findModifiers(BodyDeclaration<?> member) {
        NodeList modifiers = null;
        if (FieldDeclaration.class.isAssignableFrom(member.getClass())) {
            FieldDeclaration d = (FieldDeclaration)member;
            modifiers = d.getModifiers();
        } else if (CallableDeclaration.class.isAssignableFrom(member.getClass())) {
            CallableDeclaration d = (CallableDeclaration)member;
            modifiers = d.getModifiers();
        } else if (TypeDeclaration.class.isAssignableFrom(member.getClass())) {
            TypeDeclaration d = (TypeDeclaration)member;
            modifiers = d.getModifiers();
        }
        return Optional.ofNullable(modifiers);
    }

    private int findReplacementNode(NodeList<BodyDeclaration<?>> existingMembers, BodyDeclaration<?> member) {
        int index = -1;
        for (int i = 0; i < existingMembers.size(); ++i) {
            BodyDeclaration exists = (BodyDeclaration)existingMembers.get(i);
            if (!exists.getClass().equals(member.getClass()) || !this.memberIsReplacement(exists, member)) continue;
            index = i;
        }
        return index;
    }

    private boolean memberIsReplacement(BodyDeclaration<?> exists, BodyDeclaration<?> member) {
        boolean isReplacement = false;
        if (MethodDeclaration.class.isAssignableFrom(member.getClass())) {
            MethodDeclaration m1 = (MethodDeclaration)exists;
            MethodDeclaration m2 = (MethodDeclaration)member;
            isReplacement = m1.getName().equals((Object)m2.getName());
            List parameterTypes1 = m1.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
            List parameterTypes2 = m2.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
            isReplacement = isReplacement && parameterTypes1.equals(parameterTypes2);
        } else if (FieldDeclaration.class.isAssignableFrom(member.getClass())) {
            FieldDeclaration f1 = (FieldDeclaration)exists;
            FieldDeclaration f2 = (FieldDeclaration)member;
            isReplacement = f1.getVariable(0).getName().asString().equals(f2.getVariable(0).getName().asString());
        } else if (ClassOrInterfaceDeclaration.class.isAssignableFrom(member.getClass())) {
            isReplacement = ((ClassOrInterfaceDeclaration)exists).getName().equals((Object)((ClassOrInterfaceDeclaration)member).getName());
        } else if (ConstructorDeclaration.class.isAssignableFrom(member.getClass())) {
            ConstructorDeclaration m1 = (ConstructorDeclaration)exists;
            ConstructorDeclaration m2 = (ConstructorDeclaration)member;
            isReplacement = m1.getName().equals((Object)m2.getName());
            List parameterTypes1 = m1.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
            List parameterTypes2 = m2.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
            isReplacement = isReplacement && parameterTypes1.equals(parameterTypes2);
        } else {
            System.err.println("The type " + member.getClass().getName() + " is currently not supported. This type will not be replaced if it already exists, it will be simply be added. ");
        }
        return isReplacement;
    }

    private ClassOrInterfaceDeclaration getParent(CompilationUnit cu) {
        ClassOrInterfaceDeclaration parentNode = null;
        for (TypeDeclaration type : cu.getTypes()) {
            if (!(type instanceof ClassOrInterfaceDeclaration)) continue;
            parentNode = (ClassOrInterfaceDeclaration)type;
            break;
        }
        if (parentNode == null) {
            System.err.println("Parent node was not found in Compilation Unit below:");
            System.err.println(cu.toString());
        }
        return parentNode;
    }

    protected void write(String className, CompilationUnit existingCode) throws IOException {
        String backupFile = this.readFile(className, StandardCharsets.UTF_8);
        try (PrintWriter writer = new PrintWriter(className, "UTF-8");){
            this.write(existingCode, writer);
            writer.close();
        }
        catch (Exception e) {
            try (PrintWriter writer2 = new PrintWriter(className, "UTF-8");){
                writer2.append(backupFile);
                writer2.close();
            }
            e.printStackTrace();
        }
    }

    protected void write(CompilationUnit existingCode, PrintWriter writer) throws IOException {
        LexicalPreservingPrinter.print((Node)existingCode, (Writer)writer);
    }

    private String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

