/*
 * Decompiled with CFR 0.152.
 */
package reader;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import dataflow.GraphUtil;
import dataflow.model.DataFlowGraph;
import dataflow.model.DataFlowMethod;
import dataflow.model.DataFlowNode;
import dataflow.model.NodeCall;
import dataflow.model.NodeRepresenter;
import dataflow.model.ParameterList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reader.ImportResolver;
import reader.VariableDefintionFactory;
import templateInput.StringConverter;
import templateInput.definition.FlowReceiverDefinition;
import templateInput.definition.MethodDefinition;
import templateInput.definition.TypeDefinition;
import templateInput.definition.VariableDefinition;

public class MethodDefinitionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MethodDefinitionFactory.class);
    private ImportResolver importResolver = new ImportResolver();
    private VariableDefintionFactory fieldFactory = new VariableDefintionFactory();

    public MethodDefinition createMethod(Node node, DataFlowGraph dfg) {
        MethodDeclaration md = (MethodDeclaration)node;
        MethodDefinition method = this.parseCallable((CallableDeclaration<?>)md).build();
        method.setType(md.getTypeAsString());
        this.importResolver.resolveImport(md.getType()).forEach(method::addTypeImport);
        if (dfg != null) {
            this.addChangedFields(method, dfg.getMethod((Node)md));
            this.addMethodsCalls(method, dfg.getMethod((Node)md));
        }
        return method;
    }

    public MethodDefinition createConstructor(Node node) {
        ConstructorDeclaration md = (ConstructorDeclaration)node;
        MethodDefinition method = this.parseCallable((CallableDeclaration<?>)md).build();
        method.setType(md.getNameAsString());
        return method;
    }

    private MethodDefinition.Builder parseCallable(CallableDeclaration<?> md) {
        Set<String> accessModifiers = md.getModifiers().stream().map(Node::toString).map(String::trim).collect(Collectors.toSet());
        Set<String> annotations = md.getAnnotations().stream().map(NodeWithName::getNameAsString).collect(Collectors.toSet());
        List<VariableDefinition> params = this.getParameters(md);
        MethodDefinition.Builder builder = ((MethodDefinition.Builder)((MethodDefinition.Builder)((MethodDefinition.Builder)((MethodDefinition.Builder)((MethodDefinition.Builder)MethodDefinition.builder().name(md.getNameAsString())).accessModifiers(accessModifiers)).annotations(annotations)).parameters(params).lineNumber(md.getBegin().map(p -> p.line).orElse(-1))).column(md.getBegin().map(p -> p.column).orElse(-1))).callSignature(this.createCallSignature(md.getNameAsString(), params));
        if (md instanceof MethodDeclaration) {
            builder.type(((MethodDeclaration)md).getTypeAsString());
        } else {
            builder.type(md.getNameAsString());
        }
        return builder;
    }

    private String createCallSignature(String name, List<VariableDefinition> params) {
        String paramNames = params.stream().map(TypeDefinition::getName).map(StringConverter::toString).collect(Collectors.joining(","));
        return name + "(" + paramNames + ")";
    }

    private List<VariableDefinition> getParameters(CallableDeclaration<?> md) {
        LinkedHashMap params = new LinkedHashMap();
        md.getParameters().stream().forEach(p -> params.put(p, ((VariableDefinition.Builder)((VariableDefinition.Builder)VariableDefinition.builder().name(p.getNameAsString())).type(p.getTypeAsString())).build()));
        params.entrySet().forEach(p -> this.importResolver.resolveAndSetImport(((Parameter)p.getKey()).getType(), (TypeDefinition)p.getValue()));
        List<VariableDefinition> parameters = params.values().stream().collect(Collectors.toList());
        return parameters;
    }

    private void addChangedFields(MethodDefinition newMethod, DataFlowMethod dataFlowMethod) {
        List changedFieldsNodes = dataFlowMethod.getChangedFields();
        ArrayList<FlowReceiverDefinition> changedFields = new ArrayList<FlowReceiverDefinition>();
        for (DataFlowNode changedField : changedFieldsNodes) {
            Node javaParserNode = changedField.getRepresentedNode();
            if (javaParserNode instanceof VariableDeclarator) {
                List fieldAssigners = dataFlowMethod.getDirectInputNodesFor(changedField);
                List receivedNodes = fieldAssigners.stream().map(n -> n.walkBackUntil(arg_0 -> ((DataFlowMethod)dataFlowMethod).isInputBoundary(arg_0), arg_0 -> ((DataFlowMethod)dataFlowMethod).owns(arg_0))).flatMap(Collection::stream).collect(Collectors.toList());
                List<String> receivedNames = receivedNodes.stream().map(NodeRepresenter::getName).collect(Collectors.toList());
                VariableDefinition field = this.fieldFactory.createSingle(javaParserNode);
                FlowReceiverDefinition receiver = ((FlowReceiverDefinition.Builder)FlowReceiverDefinition.builder().copy(field)).receivedValues(receivedNames).build();
                changedFields.add(receiver);
                continue;
            }
            LOG.error("Cannot add changed field {} to method {} because represented node {} with type {} was not a VariableDeclarator", new Object[]{changedField.getName(), newMethod.getName(), javaParserNode, javaParserNode.getClass()});
        }
        newMethod.setChangedFields(changedFields);
    }

    private void addMethodsCalls(MethodDefinition newMethod, DataFlowMethod dataFlowMethod) {
        for (NodeCall call : dataFlowMethod.getNodeCalls()) {
            this.addMethodCall(newMethod, dataFlowMethod, call);
        }
    }

    private void addMethodCall(MethodDefinition newMethod, DataFlowMethod dataFlowMethod, NodeCall call) {
        MethodDefinition.Builder builder = call.getCalledMethod().map(NodeRepresenter::getRepresentedNode).map(this::parseCallable).orElse(MethodDefinition.builder());
        String type = call.getReturnNode().map(DataFlowNode::getType).orElse("void");
        ((MethodDefinition.Builder)builder.name(call.getName())).type(type);
        MethodDefinition method = this.createMethodDefinition(call);
        String returnSignature = call.getReturnNode().map(NodeRepresenter::getName).orElse(null);
        method.setReturnSignature(returnSignature);
        StringBuilder callSignature = this.createCallSignature(dataFlowMethod, call);
        method.setCallSignature(callSignature.toString());
        call.getReturnNode().map(NodeRepresenter::getName).ifPresent(method::setInstance);
        String expectedReturn = this.createExpecedReturn(newMethod, dataFlowMethod, call, returnSignature);
        newMethod.setExpectedReturn(expectedReturn);
        if (call.isReturnRead()) {
            newMethod.addInputMethod(method);
        } else {
            newMethod.addOutputMethod(method);
        }
    }

    private String createExpecedReturn(MethodDefinition newMethod, DataFlowMethod dataFlowMethod, NodeCall call, String returnSignature) {
        String expectedReturn = null;
        if (call.getReturnNode().isPresent() && dataFlowMethod.getReturnNode().isPresent()) {
            DataFlowNode methodReturn = (DataFlowNode)dataFlowMethod.getReturnNode().get();
            DataFlowNode callReturn = (DataFlowNode)call.getReturnNode().get();
            List walkBackUntil = methodReturn.walkBackUntil(arg_0 -> ((DataFlowNode)callReturn).equals(arg_0), arg_0 -> ((DataFlowMethod)dataFlowMethod).owns(arg_0));
            if (!walkBackUntil.isEmpty()) {
                expectedReturn = newMethod.getExpectedReturn() == null ? returnSignature : newMethod.getExpectedReturn() + "__" + returnSignature;
            }
        }
        return expectedReturn;
    }

    private StringBuilder createCallSignature(DataFlowMethod dataFlowMethod, NodeCall call) {
        List inputParameters = call.getIn().map(ParameterList::getNodes).orElse(new ArrayList());
        StringBuilder callSignature = new StringBuilder();
        callSignature.append(call.getName()).append("(");
        boolean first = true;
        for (DataFlowNode param : inputParameters) {
            if (!first) {
                callSignature.append(", ");
            } else {
                first = false;
            }
            String inputName = this.getInputName(dataFlowMethod, param);
            callSignature.append(inputName);
        }
        callSignature.append(")");
        return callSignature;
    }

    private MethodDefinition createMethodDefinition(NodeCall call) {
        MethodDefinition method = null;
        method = call.getCalledMethod().isPresent() ? this.parseCallable((CallableDeclaration)((DataFlowMethod)call.getCalledMethod().get()).getRepresentedNode()).build() : ((MethodDefinition.Builder)MethodDefinition.builder().type(call.getClaz())).build();
        return method;
    }

    private String getInputName(DataFlowMethod dataFlowMethod, DataFlowNode param) {
        Predicate<DataFlowNode> isField = DataFlowNode::isField;
        Predicate<DataFlowNode> isParam = DataFlowNode::isInputParameter;
        Predicate<DataFlowNode> isMethodCallReturn = n -> n.getOwner().filter(o -> NodeCall.class.isAssignableFrom(o.getClass())).map(NodeCall.class::cast).filter(t -> !t.getCalledMethod().isPresent() || !((DataFlowMethod)t.getCalledMethod().get()).getOwner().equals(dataFlowMethod.getOwner())).isPresent();
        Predicate<DataFlowNode> hasNoInput = dfn -> dfn.getIn().isEmpty();
        List inputNodes = GraphUtil.walkBackUntil((DataFlowNode)param, isField.or(isParam).or(isMethodCallReturn).or(hasNoInput), arg_0 -> ((DataFlowGraph)dataFlowMethod.getGraph()).owns(arg_0));
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (DataFlowNode inputNode : inputNodes) {
            if (!first) {
                sb.append("_");
            } else {
                first = false;
            }
            if (param.isField()) {
                sb.append(inputNode.getName());
                continue;
            }
            if (inputNode.isInputParameter()) {
                sb.append(inputNode.getName());
                continue;
            }
            if (isMethodCallReturn.test(inputNode)) {
                sb.append(inputNode.getName());
                continue;
            }
            if (hasNoInput.test(inputNode)) {
                sb.append(inputNode.getName());
                continue;
            }
            sb.append(inputNode.getName());
        }
        return sb.toString();
    }
}

