/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.EmptyExpression;
import com.github.developframework.expression.ObjectExpression;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public abstract class Expression {
    public static final EmptyExpression EMPTY_EXPRESSION = new EmptyExpression();
    protected Expression parentExpression;

    public boolean hasParentExpression() {
        return this.parentExpression != null;
    }

    public Expression[] expressionTree() {
        LinkedList<Expression> expressionTree = new LinkedList<Expression>();
        Expression tempExpression = this;
        while (tempExpression != null) {
            expressionTree.add(tempExpression);
            tempExpression = tempExpression.parentExpression;
        }
        Collections.reverse(expressionTree);
        return expressionTree.toArray(new Expression[expressionTree.size()]);
    }

    public static final Expression parse(String expressionValue) {
        if (StringUtils.isNotBlank((CharSequence)expressionValue)) {
            if (expressionValue.contains(".")) {
                String[] expressionFragments = expressionValue.split("\\.");
                Expression rootExpression = Expression.parseSingle(expressionFragments[0]);
                for (int i = 1; i < expressionFragments.length; ++i) {
                    Expression childExpression = Expression.parseSingle(expressionFragments[i]);
                    childExpression.setParentExpression(rootExpression);
                    rootExpression = childExpression;
                }
                return rootExpression;
            }
            return Expression.parseSingle(expressionValue);
        }
        return EMPTY_EXPRESSION;
    }

    private static final Expression parseSingle(String singleExpressionValue) {
        if (StringUtils.isBlank((CharSequence)singleExpressionValue)) {
            return EMPTY_EXPRESSION;
        }
        if (ArrayExpression.isArrayExpression(singleExpressionValue)) {
            return new ArrayExpression(singleExpressionValue);
        }
        return new ObjectExpression(singleExpressionValue);
    }

    public static final Expression copy(Expression expression) {
        Expression newExpression;
        if (expression instanceof ObjectExpression) {
            newExpression = new ObjectExpression(((ObjectExpression)expression).getPropertyName());
        } else if (expression instanceof ArrayExpression) {
            ArrayExpression arrayExpression = (ArrayExpression)expression;
            newExpression = new ArrayExpression(arrayExpression.getPropertyName(), arrayExpression.getIndex());
        } else {
            newExpression = EMPTY_EXPRESSION;
        }
        if (expression.getParentExpression() != null) {
            newExpression.setParentExpression(Expression.copy(expression.getParentExpression()));
        }
        return newExpression;
    }

    public static final Expression concat(Expression parentExpression, String childExpressionValue) {
        Expression newExpression = Expression.parse(childExpressionValue);
        if (parentExpression != EMPTY_EXPRESSION) {
            newExpression.setParentExpression(parentExpression);
        }
        return newExpression;
    }

    public static final Expression concat(Expression parentExpression, Expression childExpression) {
        Expression newExpression = Expression.copy(childExpression);
        if (parentExpression != EMPTY_EXPRESSION) {
            newExpression.setParentExpression(parentExpression);
        }
        return newExpression;
    }

    public Expression getParentExpression() {
        return this.parentExpression;
    }

    public void setParentExpression(Expression parentExpression) {
        this.parentExpression = parentExpression;
    }
}

