/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.expression.exception.ExpressionException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ExpressionUtils {
    private ExpressionUtils() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static final Object getValue(Object instance, String expressionValue) {
        return ExpressionUtils.getValue(instance, Expression.parse(expressionValue));
    }

    public static final <T> T getValue(Object instance, String expressionValue, Class<T> targetClass) {
        return (T)ExpressionUtils.getValue(instance, Expression.parse(expressionValue));
    }

    public static final <T> T getValue(Object instance, Expression expression, Class<T> targetClass) {
        return (T)ExpressionUtils.getValue(instance, expression);
    }

    public static final Object getValue(Object instance, Expression expression) {
        Objects.requireNonNull(instance);
        if (expression == null) {
            return null;
        }
        if (expression == Expression.EMPTY_EXPRESSION) {
            return instance;
        }
        Expression[] expressionTree = expression.expressionTree();
        Object tempObject = instance;
        for (Expression singleExpression : expressionTree) {
            if (singleExpression instanceof ObjectExpression) {
                tempObject = ExpressionUtils.getValueFromObjectOrMap(tempObject, ((ObjectExpression)singleExpression).getPropertyName());
                continue;
            }
            if (!(singleExpression instanceof ArrayExpression)) continue;
            tempObject = ExpressionUtils.getValueFromArray(tempObject, (ArrayExpression)singleExpression);
        }
        return tempObject;
    }

    private static final Object getValueFromObjectOrMap(Object instance, String propertyName) {
        Class<?> clazz = instance.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            return ((Map)instance).get(propertyName);
        }
        try {
            Field field = clazz.getDeclaredField(propertyName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (NoSuchFieldException e) {
            throw new ExpressionException("No such field \"%s\" in class \"%s\".", propertyName, clazz.getName());
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException("Illegal access field \"%s\" in class \"%s\".", propertyName, clazz.getName());
        }
    }

    private static final Object getValueFromArray(Object instance, ArrayExpression arrayExpression) {
        Class<?> clazz;
        Object arrayObject = instance;
        if (arrayExpression.hasPropertyName()) {
            arrayObject = ExpressionUtils.getValueFromObjectOrMap(instance, arrayExpression.getPropertyName());
        }
        if ((clazz = arrayObject.getClass()).isArray()) {
            return ((Object[])arrayObject)[arrayExpression.getIndex()];
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ((List)arrayObject).get(arrayExpression.getIndex());
        }
        throw new ExpressionException("The instance \"%s\" type is not array or List.", instance.toString());
    }
}

