/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.Expression;

public class ObjectExpression
extends Expression {
    private String propertyName;

    public ObjectExpression(String propertyName) {
        this.propertyName = propertyName;
    }

    public String toString() {
        if (this.parentExpression == null) {
            return this.propertyName;
        }
        return this.parentExpression + "." + this.propertyName;
    }

    public int hashCode() {
        int hash = 7;
        if (this.hasParentExpression()) {
            hash = hash * 31 + this.parentExpression.hashCode();
        }
        hash = hash * 31 + this.propertyName.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        ObjectExpression otherExpression;
        if (obj instanceof ObjectExpression && this.propertyName.equals((otherExpression = (ObjectExpression)obj).getPropertyName())) {
            if (this.hasParentExpression() && otherExpression.hasParentExpression()) {
                return this.parentExpression.equals(otherExpression.getParentExpression());
            }
            return !this.hasParentExpression() && !this.hasParentExpression();
        }
        return false;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

