/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.EmptyExpression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.expression.exception.ExpressionException;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public abstract class Expression {
    public static final EmptyExpression EMPTY_EXPRESSION = new EmptyExpression();
    protected Expression parentExpression = EMPTY_EXPRESSION;

    public void setParentExpression(Expression parentExpression) {
        if (parentExpression == null) {
            throw new ExpressionException("can't set null to parent expression.");
        }
        this.parentExpression = parentExpression;
    }

    public boolean hasParentExpression() {
        return this.parentExpression != EMPTY_EXPRESSION;
    }

    public Expression[] expressionTree() {
        LinkedList<Expression> expressionTree = new LinkedList<Expression>();
        Expression tempExpression = this;
        while (tempExpression != EMPTY_EXPRESSION) {
            expressionTree.add(tempExpression);
            tempExpression = tempExpression.parentExpression;
        }
        Collections.reverse(expressionTree);
        return expressionTree.toArray(new Expression[0]);
    }

    public static final Expression parse(String expressionValue) {
        if (StringUtils.isNotBlank((CharSequence)expressionValue)) {
            if (expressionValue.contains(".")) {
                String[] expressionFragments = expressionValue.split("\\.");
                Expression rootExpression = Expression.parseSingle(expressionFragments[0]);
                for (int i = 1; i < expressionFragments.length; ++i) {
                    Expression childExpression = Expression.parseSingle(expressionFragments[i]);
                    childExpression.setParentExpression(rootExpression);
                    rootExpression = childExpression;
                }
                return rootExpression;
            }
            return Expression.parseSingle(expressionValue);
        }
        return EMPTY_EXPRESSION;
    }

    private static Expression parseSingle(String singleExpressionValue) {
        if (StringUtils.isBlank((CharSequence)singleExpressionValue)) {
            return EMPTY_EXPRESSION;
        }
        if (ArrayExpression.isArrayExpression(singleExpressionValue)) {
            return new ArrayExpression(singleExpressionValue);
        }
        return new ObjectExpression(singleExpressionValue);
    }

    public static final Expression copy(Expression expression) {
        Expression newExpression;
        if (expression instanceof ObjectExpression) {
            newExpression = new ObjectExpression(((ObjectExpression)expression).getPropertyName());
        } else if (expression instanceof ArrayExpression) {
            ArrayExpression arrayExpression = (ArrayExpression)expression;
            newExpression = new ArrayExpression(arrayExpression.getPropertyName(), arrayExpression.getIndex());
        } else {
            newExpression = EMPTY_EXPRESSION;
        }
        if (expression.getParentExpression() != EMPTY_EXPRESSION) {
            newExpression.setParentExpression(Expression.copy(expression.getParentExpression()));
        } else {
            newExpression.setParentExpression(EMPTY_EXPRESSION);
        }
        return newExpression;
    }

    public static final Expression concat(Expression parentExpression, String childExpressionValue) {
        Expression childExpression = Expression.parse(childExpressionValue);
        return Expression.concat(parentExpression, childExpression);
    }

    public static final Expression concat(Expression parentExpression, Expression childExpression) {
        if (childExpression == EMPTY_EXPRESSION) {
            return parentExpression;
        }
        if (parentExpression == EMPTY_EXPRESSION) {
            return childExpression;
        }
        Expression newExpression = Expression.copy(childExpression);
        if (newExpression.getParentExpression() == EMPTY_EXPRESSION) {
            newExpression.setParentExpression(parentExpression);
        } else {
            newExpression.getParentExpression().setParentExpression(parentExpression);
        }
        return newExpression;
    }

    public Expression getParentExpression() {
        return this.parentExpression;
    }
}

