/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.EmptyExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.expression.exception.ExpressionParseException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ArrayExpression
extends Expression {
    private String propertyName;
    private int index;

    public ArrayExpression(@NonNull String propertyName, int index) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        this.propertyName = propertyName;
        this.index = index;
    }

    protected ArrayExpression(@NonNull String expressionValue) {
        if (expressionValue == null) {
            throw new NullPointerException("expressionValue is marked non-null but is null");
        }
        if (!ArrayExpression.isArrayExpression(expressionValue)) {
            throw new ExpressionParseException("The expression \"%s\" is not a array type expression.", expressionValue);
        }
        this.propertyName = StringUtils.substringBefore((String)expressionValue, (String)"[");
        try {
            this.index = Integer.parseInt(StringUtils.substringBetween((String)expressionValue, (String)"[", (String)"]"));
        }
        catch (NumberFormatException e) {
            throw new ExpressionParseException("The expression \"%s\": index is not a number.", expressionValue);
        }
    }

    public boolean hasPropertyName() {
        return StringUtils.isNotEmpty((CharSequence)this.propertyName);
    }

    public String toString() {
        if (this.parentExpression == EmptyExpression.INSTANCE) {
            return this.propertyName + "[" + this.index + "]";
        }
        return this.parentExpression + "." + this.propertyName + "[" + this.index + "]";
    }

    public int hashCode() {
        int hash = 7;
        if (this.hasParentExpression()) {
            hash = hash * 31 + this.parentExpression.hashCode();
        }
        hash = hash * 31 + this.propertyName.hashCode();
        hash = hash * 31 + this.index;
        return hash;
    }

    public boolean equals(Object obj) {
        ArrayExpression otherExpression;
        if (obj instanceof ArrayExpression && this.propertyName.equals((otherExpression = (ArrayExpression)obj).getPropertyName()) && this.index == otherExpression.getIndex()) {
            return this.parentExpression.equals(otherExpression.getParentExpression());
        }
        return false;
    }

    public static boolean isArrayExpression(String expressionValue) {
        return expressionValue.matches("^\\w*(\\[\\w+])+$");
    }

    public static ArrayExpression fromObject(ObjectExpression objectExpression, int index) {
        ArrayExpression arrayExpression = new ArrayExpression(objectExpression.getPropertyName(), index);
        arrayExpression.setParentExpression(objectExpression.getParentExpression());
        return arrayExpression;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public int getIndex() {
        return this.index;
    }
}

