/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.EmptyExpression;
import com.github.developframework.expression.MethodExpression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.expression.exception.ExpressionException;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public abstract class Expression {
    protected Expression parentExpression = EmptyExpression.INSTANCE;

    public void setParentExpression(Expression parentExpression) {
        if (parentExpression == null) {
            throw new ExpressionException("can't set null to parent expression.");
        }
        this.parentExpression = parentExpression;
    }

    public boolean hasParentExpression() {
        return this.parentExpression != EmptyExpression.INSTANCE;
    }

    public Expression[] expressionTree() {
        LinkedList<Expression> expressionTree = new LinkedList<Expression>();
        Expression tempExpression = this;
        while (tempExpression != EmptyExpression.INSTANCE) {
            expressionTree.add(tempExpression);
            tempExpression = tempExpression.parentExpression;
        }
        Collections.reverse(expressionTree);
        return expressionTree.toArray(new Expression[0]);
    }

    public static Expression parse(String expressionValue) {
        if (StringUtils.isNotEmpty((CharSequence)expressionValue)) {
            if (expressionValue.contains(".")) {
                String[] expressionFragments = Expression.split(expressionValue);
                Expression rootExpression = Expression.parseSingle(expressionFragments[0]);
                for (int i = 1; i < expressionFragments.length; ++i) {
                    Expression childExpression = Expression.parseSingle(expressionFragments[i]);
                    childExpression.setParentExpression(rootExpression);
                    rootExpression = childExpression;
                }
                return rootExpression;
            }
            return Expression.parseSingle(expressionValue);
        }
        return EmptyExpression.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] split(String expressionValue) {
        if (!expressionValue.contains("(")) {
            return expressionValue.split("\\.");
        }
        LinkedList<String> parts = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        int inBracketLevel = 0;
        block5: for (int i = 0; i < expressionValue.length(); ++i) {
            char ch = expressionValue.charAt(i);
            switch (ch) {
                case '(': {
                    ++inBracketLevel;
                    break;
                }
                case ')': {
                    --inBracketLevel;
                    break;
                }
                case '.': {
                    if (inBracketLevel == 0) {
                        parts.add(sb.toString());
                        sb.setLength(0);
                        inBracketLevel = 0;
                        continue block5;
                    }
                    sb.append(ch);
                    continue block5;
                }
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            parts.add(sb.toString());
        }
        return (String[])parts.toArray(String[]::new);
    }

    private static Expression parseSingle(String singleExpressionValue) {
        if (StringUtils.isEmpty((CharSequence)singleExpressionValue)) {
            return EmptyExpression.INSTANCE;
        }
        if (ArrayExpression.isArrayExpression(singleExpressionValue)) {
            return new ArrayExpression(singleExpressionValue);
        }
        if (MethodExpression.isMethodExpression(singleExpressionValue)) {
            return new MethodExpression(singleExpressionValue);
        }
        return new ObjectExpression(singleExpressionValue);
    }

    public static Expression copy(Expression expression) {
        Expression newExpression;
        if (expression instanceof ObjectExpression) {
            newExpression = new ObjectExpression(((ObjectExpression)expression).getPropertyName());
        } else if (expression instanceof ArrayExpression) {
            ArrayExpression arrayExpression = (ArrayExpression)expression;
            newExpression = new ArrayExpression(arrayExpression.getPropertyName(), arrayExpression.getIndex());
        } else {
            newExpression = EmptyExpression.INSTANCE;
        }
        if (expression.getParentExpression() != EmptyExpression.INSTANCE) {
            newExpression.setParentExpression(Expression.copy(expression.getParentExpression()));
        } else {
            newExpression.setParentExpression(EmptyExpression.INSTANCE);
        }
        return newExpression;
    }

    public static Expression concat(Expression parentExpression, String childExpressionValue) {
        Expression childExpression = Expression.parse(childExpressionValue);
        return Expression.concat(parentExpression, childExpression);
    }

    public static Expression concat(Expression parentExpression, Expression childExpression) {
        if (childExpression == EmptyExpression.INSTANCE) {
            return parentExpression;
        }
        if (parentExpression == EmptyExpression.INSTANCE) {
            return childExpression;
        }
        Expression newExpression = Expression.copy(childExpression);
        if (newExpression.getParentExpression() == EmptyExpression.INSTANCE) {
            newExpression.setParentExpression(parentExpression);
        } else {
            newExpression.getParentExpression().setParentExpression(parentExpression);
        }
        return newExpression;
    }

    public Expression getParentExpression() {
        return this.parentExpression;
    }
}

