/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.EmptyExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.exception.ExpressionParseException;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class MethodExpression
extends Expression {
    private String methodName;
    private Expression[] arguments;

    public MethodExpression(String methodName, Expression[] arguments) {
        this.methodName = methodName;
        this.arguments = arguments;
    }

    protected MethodExpression(String expressionValue) {
        if (!MethodExpression.isMethodExpression(expressionValue)) {
            throw new ExpressionParseException("The Expression \"%s\" is not a method expression.", expressionValue);
        }
        this.methodName = StringUtils.substringBefore((String)expressionValue, (String)"(");
        String argumentString = expressionValue.substring(expressionValue.indexOf("(") + 1, expressionValue.lastIndexOf(")"));
        this.arguments = (Expression[])Stream.of(argumentString.split("\\s*,\\s*")).map(Expression::parse).filter(e -> e != EmptyExpression.INSTANCE).toArray(Expression[]::new);
    }

    public String toString() {
        if (this.parentExpression == EmptyExpression.INSTANCE) {
            return this.methodName;
        }
        return this.parentExpression + "." + this.methodName + "(" + StringUtils.join((Object[])this.arguments, (String)",") + ")";
    }

    public int hashCode() {
        int hash = 7;
        if (this.hasParentExpression()) {
            hash = hash * 31 + this.parentExpression.hashCode();
        }
        hash = hash * 31 + this.methodName.hashCode();
        for (Expression argument : this.arguments) {
            hash = hash * 31 + argument.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        MethodExpression otherExpression;
        if (this == obj) {
            return true;
        }
        if (obj instanceof MethodExpression && this.parentExpression.equals((otherExpression = (MethodExpression)obj).getParentExpression()) && this.methodName.equals(otherExpression.methodName) && this.arguments.length == otherExpression.arguments.length) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].equals(otherExpression.arguments[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isMethodExpression(String expressionValue) {
        return expressionValue.matches("^\\w+\\((.+(\\s*,\\s*.+)*)?\\)$");
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Expression[] getArguments() {
        return this.arguments;
    }
}

