/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import java.io.Serializable;

public class PortBinding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Ports.Binding binding;
    private final ExposedPort exposedPort;

    public PortBinding(Ports.Binding binding, ExposedPort exposedPort) {
        this.binding = binding;
        this.exposedPort = exposedPort;
    }

    public Ports.Binding getBinding() {
        return this.binding;
    }

    public ExposedPort getExposedPort() {
        return this.exposedPort;
    }

    public static PortBinding parse(String serialized) throws IllegalArgumentException {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 3: {
                    return PortBinding.createFromSubstrings(parts[0] + ":" + parts[1], parts[2]);
                }
                case 2: {
                    return PortBinding.createFromSubstrings(parts[0], parts[1]);
                }
                case 1: {
                    return PortBinding.createFromSubstrings("", parts[0]);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing PortBinding '" + serialized + "'", e);
        }
    }

    private static PortBinding createFromSubstrings(String binding, String exposedPort) throws IllegalArgumentException {
        return new PortBinding(Ports.Binding.parse(binding), ExposedPort.parse(exposedPort));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PortBinding)) {
            return false;
        }
        PortBinding other = (PortBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Ports.Binding this$binding = this.getBinding();
        Ports.Binding other$binding = other.getBinding();
        if (this$binding == null ? other$binding != null : !((Object)this$binding).equals(other$binding)) {
            return false;
        }
        ExposedPort this$exposedPort = this.getExposedPort();
        ExposedPort other$exposedPort = other.getExposedPort();
        return !(this$exposedPort == null ? other$exposedPort != null : !((Object)this$exposedPort).equals(other$exposedPort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PortBinding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Ports.Binding $binding = this.getBinding();
        result = result * 59 + ($binding == null ? 43 : ((Object)$binding).hashCode());
        ExposedPort $exposedPort = this.getExposedPort();
        result = result * 59 + ($exposedPort == null ? 43 : ((Object)$exposedPort).hashCode());
        return result;
    }

    public String toString() {
        return "PortBinding(binding=" + this.getBinding() + ", exposedPort=" + this.getExposedPort() + ")";
    }
}

