/*
 * Decompiled with CFR 0.152.
 */
package com.github.hermod.ser;

import java.util.Arrays;

public enum Precision {
    UNITS(1.0),
    TENTHS(0.1),
    HUNDREDTHS(0.01),
    THOUSANDTHS(0.001),
    TEN_THOUSANDTHS(1.0E-4),
    HUNDRED_THOUSANDTHS(1.0E-5),
    MILLIONTHS(1.0E-6),
    TEN_MILLIONTHS(1.0E-7),
    HUNDRED_MILLIONTHS(1.0E-8),
    TENS(10.0),
    HUNDREDS(100.0),
    THOUSANDS(1000.0),
    TEN_THOUSANDS(10000.0),
    HUNDRED_THOUSANDS(100000.0),
    MILLIONS(1000000.0),
    TEN_MILLIONS(1.0E7),
    HUNDRED_MILLIONS(1.0E8);

    private static final Precision[] NEGATIVE_NB_DIGIT_PRECISION;
    private static final Precision[] POSITIVE_NB_DIGIT_PRECISION;
    public static final double HALF = 0.5;
    private final double precision;
    private final int nbDigit;

    private Precision(double aPrecision) {
        this.precision = aPrecision;
        this.nbDigit = (int)(-Math.log10(this.precision));
    }

    public final double calculateIntegerMantissa(double aValue) {
        double mantissa = aValue / this.precision + 0.5;
        return mantissa >= -2.147483648E9 && mantissa <= 2.147483647E9 ? mantissa : Double.NaN;
    }

    public final double calculateDoubleFromIntegerMantissa(long aValue) {
        return (double)aValue * this.precision;
    }

    public final int getNbDigit() {
        return this.nbDigit;
    }

    public final double getPrecision() {
        return this.precision;
    }

    public static Precision valueOf(int nbDigit) {
        try {
            return nbDigit >= 0 ? POSITIVE_NB_DIGIT_PRECISION[nbDigit] : NEGATIVE_NB_DIGIT_PRECISION[-nbDigit];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Precision not found with nbDigit=" + nbDigit + " in " + Arrays.asList(Precision.values()), e);
        }
    }

    public static final Precision valueOf(double aPrecision) {
        for (Precision precision : Precision.values()) {
            if (aPrecision != precision.getPrecision()) continue;
            return precision;
        }
        throw new IllegalArgumentException("Precision not found with precision=" + aPrecision + " in " + Arrays.asList(Precision.values()));
    }

    static {
        int maxNbDigitPrecision = 0;
        int minNbDigitPrecision = 0;
        for (Precision precision : Precision.values()) {
            if (precision.getNbDigit() > maxNbDigitPrecision) {
                maxNbDigitPrecision = precision.getNbDigit();
            }
            if (precision.getNbDigit() >= minNbDigitPrecision) continue;
            minNbDigitPrecision = precision.getNbDigit();
        }
        NEGATIVE_NB_DIGIT_PRECISION = new Precision[-minNbDigitPrecision + 1];
        POSITIVE_NB_DIGIT_PRECISION = new Precision[maxNbDigitPrecision + 1];
        for (Precision precision : Precision.values()) {
            if (precision.getNbDigit() >= 0) {
                Precision.POSITIVE_NB_DIGIT_PRECISION[precision.getNbDigit()] = precision;
                continue;
            }
            Precision.NEGATIVE_NB_DIGIT_PRECISION[-precision.getNbDigit()] = precision;
        }
    }
}

