/*
 * Decompiled with CFR 0.152.
 */
package com.github.hermod.ser;

import com.github.hermod.ser.Null;
import com.github.hermod.ser.Type;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class NullTest {
    @Test
    public void testGetLength() {
        for (int i = 0; i < 64; ++i) {
            Null nul = Null.valueOf((int)i);
            Assertions.assertThat((int)nul.getLength()).isEqualTo(i);
        }
    }

    @Test
    public void testGetType() {
        for (int i = 0; i < 64; ++i) {
            Null nul = Null.valueOf((int)i);
            Assertions.assertThat((Object)nul.getType()).isEqualTo((Object)Type.NULL);
        }
        for (Type type : Type.values()) {
            Null nul;
            if (type == Type.SKIPPED_KEYS) {
                try {
                    nul = Null.valueOf((Type)type);
                }
                catch (Exception e) {
                    Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
                }
                continue;
            }
            nul = Null.valueOf((Type)type);
            Assertions.assertThat((Object)nul.getType()).isEqualTo((Object)type);
        }
    }

    @Test
    public void testValueOf() {
        for (int i = 0; i < 64; ++i) {
            Null nul = Null.valueOf((int)i);
            Assertions.assertThat((Object)nul).isEqualTo((Object)Null.valueOf((int)i));
            Assertions.assertThat((int)nul.hashCode()).isEqualTo(Null.valueOf((int)i).hashCode());
            Assertions.assertThat((Object)nul).isNotEqualTo((Object)Null.valueOf((int)(i + 1)));
            Assertions.assertThat((boolean)nul.equals(null)).isFalse();
            Assertions.assertThat((boolean)nul.equals((Object)i)).isFalse();
        }
        for (Type type : Type.values()) {
            Null nul;
            if (type == Type.SKIPPED_KEYS) {
                try {
                    nul = Null.valueOf((Type)type);
                }
                catch (Exception e) {
                    Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
                }
                continue;
            }
            nul = Null.valueOf((Type)type);
            Assertions.assertThat((Object)nul.getType()).isEqualTo((Object)type);
        }
        try {
            Null nul = Null.valueOf(null);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValueOfWithNegativeLength() {
        Null.valueOf((int)-1);
    }
}

