/*
 * Decompiled with CFR 0.152.
 */
package com.github.hermod.ser;

import com.github.hermod.ser.Msg;
import com.github.hermod.ser.Null;
import com.github.hermod.ser.Type;
import java.math.BigInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TypeTest {
    @Test
    public void testValueOf() {
        Assertions.assertThat((Object)Type.valueOf((String)"INTEGER")).isEqualTo((Object)Type.INTEGER);
        Assertions.assertThat((Object)Type.valueOf((byte)64)).isEqualTo((Object)Type.INTEGER);
        Assertions.assertThat((Object)Type.valueOf((byte)-96)).isEqualTo((Object)Type.MSG);
        Assertions.assertThat((Object)Type.valueOf(Boolean.class)).isEqualTo((Object)Type.BYTE);
        Assertions.assertThat((Object)Type.valueOf(Short.class)).isEqualTo((Object)Type.SHORT);
        Assertions.assertThat((Object)Type.valueOf(Integer.class)).isEqualTo((Object)Type.INT);
        Assertions.assertThat((Object)Type.valueOf(Long.class)).isEqualTo((Object)Type.LONG);
        Assertions.assertThat((Object)Type.valueOf(Float.class)).isEqualTo((Object)Type.FLOAT);
        Assertions.assertThat((Object)Type.valueOf(Double.class)).isEqualTo((Object)Type.DOUBLE);
        Assertions.assertThat((Object)Type.valueOf(String.class)).isEqualTo((Object)Type.STRING_UTF8);
        Assertions.assertThat((Object)Type.valueOf(Msg.class)).isEqualTo((Object)Type.MSG);
        Assertions.assertThat((Object)Type.valueOf(CustomMsg.class)).isEqualTo((Object)Type.MSG);
        Assertions.assertThat((Object)Type.valueOf(byte[].class)).isEqualTo((Object)Type.ARRAY_FIXED_VALUE);
        Assertions.assertThat((Object)Type.valueOf(Long[].class)).isEqualTo((Object)Type.ARRAY_VARIABLE_VALUE);
        Assertions.assertThat((Object)Type.valueOf(Null.class)).isEqualTo((Object)Type.NULL);
        try {
            Assertions.assertThat((Object)Type.valueOf((byte)1));
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
        try {
            Assertions.assertThat((Object)Type.valueOf(BigInteger.class));
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testGetShiftId() {
        Assertions.assertThat((byte)Type.valueOf((String)"INTEGER").getShiftId()).isEqualTo((byte)2);
    }

    public static class CustomMsg
    implements Msg {
        public boolean isEmpty() {
            return false;
        }

        public boolean isSerializable() {
            return false;
        }

        public boolean isBytesSerializable() {
            return false;
        }

        public boolean isByteBufferSerializable() {
            return false;
        }

        public boolean isByteBufSerializable() {
            return false;
        }

        public int[] getKeysArray() {
            return null;
        }

        public int getKeyMax() {
            return 0;
        }

        public int getKeysLength() {
            return 0;
        }

        public Type getType(int aKey) {
            return null;
        }

        public byte getTypeAsByte(int aKey) {
            return 0;
        }

        public boolean isArray(int aKey) {
            return false;
        }

        public int getArrayLength(int aKey) {
            return 0;
        }

        public boolean contains(int aKey) {
            return false;
        }

        public Object get(int aKey) {
            return null;
        }

        public <T> T get(int aKey, Class<T> aClazz) {
            return null;
        }

        public Null getAsNull(int aKey) {
            return null;
        }

        public boolean getAsBoolean(int aKey) {
            return false;
        }

        public Boolean getAsNullableBoolean(int aKey) {
            return null;
        }

        public byte getAsByte(int aKey) {
            return 0;
        }

        public Byte getAsNullableByte(int aKey) {
            return null;
        }

        public short getAsShort(int aKey) {
            return 0;
        }

        public Short getAsNullableShort(int aKey) {
            return null;
        }

        public int getAsInt(int aKey) {
            return 0;
        }

        public Integer getAsNullableInteger(int aKey) {
            return null;
        }

        public long getAsLong(int aKey) {
            return 0L;
        }

        public Long getAsNullableLong(int aKey) {
            return null;
        }

        public float getAsFloat(int aKey) {
            return 0.0f;
        }

        public Float getAsNullableFloat(int aKey) {
            return null;
        }

        public double getAsDouble(int aKey) {
            return 0.0;
        }

        public Double getAsNullableDouble(int aKey) {
            return null;
        }

        public String getAsString(int aKey) {
            return null;
        }

        public Msg getAsMsg(int aKey) {
            return null;
        }

        public void getAsMsg(int aKey, Msg aDestMsg) {
        }

        public boolean[] getAsBooleans(int aKey) {
            return null;
        }

        public Boolean[] getAsNullableBooleans(int aKey) {
            return null;
        }

        public byte[] getAsBytes(int aKey) {
            return null;
        }

        public Byte[] getAsNullableBytes(int aKey) {
            return null;
        }

        public short[] getAsShorts(int aKey) {
            return null;
        }

        public Short[] getAsNullableShorts(int aKey) {
            return null;
        }

        public int[] getAsInts(int aKey) {
            return null;
        }

        public Integer[] getAsNullableIntegers(int aKey) {
            return null;
        }

        public long[] getAsLongs(int aKey) {
            return null;
        }

        public Long[] getAsNullableLongs(int aKey) {
            return null;
        }

        public float[] getAsFloats(int aKey) {
            return null;
        }

        public Float[] getAsNullableFloats(int aKey) {
            return null;
        }

        public double[] getAsDoubles(int aKey) {
            return null;
        }

        public Double[] getAsNullableDoubles(int aKey) {
            return null;
        }

        public String[] getAsStrings(int aKey) {
            return null;
        }

        public Msg[] getAsMsgs(int aKey) {
            return null;
        }

        public void getAsMsgs(int aKey, Msg ... aDestMsgs) {
        }

        public Object[] getAsObjects(int aKey) {
            return null;
        }

        public Msg getAllAsMsg() {
            return null;
        }

        public Object[] getAllAsObjects() {
            return null;
        }

        public void getAllAsObjects(Object ... aObjects) {
        }

        public void set(int aKey, Null aNull) {
        }

        public void set(int aKey, Object aAnObject) {
        }

        public void set(int aKey, Object aObject, boolean aOptimizeLength) {
        }

        public void set(int aKey, boolean aBoolean) {
        }

        public void set(int aKey, Boolean aBoolean) {
        }

        public void set(int aKey, Boolean aBoolean, boolean aOptimizeLength) {
        }

        public void set(int aKey, byte aByte) {
        }

        public void set(int aKey, Byte aByte) {
        }

        public void set(int aKey, Byte aByte, boolean aOptimizeLength) {
        }

        public void set(int aKey, short aShort) {
        }

        public void set(int aKey, short aShort, boolean aOptimizeLength) {
        }

        public void set(int aKey, Short aShort) {
        }

        public void set(int aKey, Short aShort, boolean aOptimizeLength) {
        }

        public void set(int aKey, int aInt) {
        }

        public void set(int aKey, int aInt, boolean aOptimizeLength) {
        }

        public void set(int aKey, Integer aInt) {
        }

        public void set(int aKey, Integer aInt, boolean aOptimizeLength) {
        }

        public void set(int aKey, long aLong) {
        }

        public void set(int aKey, long aLong, boolean aOptimizeLength) {
        }

        public void set(int aKey, Long aLong) {
        }

        public void set(int aKey, Long aLong, boolean aOptimizeLength) {
        }

        public void set(int aKey, float aFloat) {
        }

        public void set(int aKey, Float aFloat) {
        }

        public void set(int aKey, Float aFloat, boolean aOptimizeLength) {
        }

        public void set(int aKey, double aDouble) {
        }

        public void set(int aKey, double aDouble, boolean aOptimizeLength) {
        }

        public void set(int aKey, Double aDouble) {
        }

        public void set(int aKey, Double aDouble, boolean aOptimizeLength) {
        }

        public void set(int aKey, double aDouble, int aScale) {
        }

        public void set(int aKey, Double aDouble, int aScale) {
        }

        public void set(int aKey, Double aDouble, int aScale, boolean aOptimizeLength) {
        }

        public void set(int aKey, String aString) {
        }

        public void set(int aKey, String aString, boolean aForceAsciiEncoding) {
        }

        public void set(int aKey, Msg aMsg) {
        }

        public void set(int aKey, boolean ... aBooleans) {
        }

        public void set(int aKey, Boolean ... aBooleans) {
        }

        public void set(int aKey, byte ... aBytes) {
        }

        public void set(int aKey, Byte ... aBytes) {
        }

        public void set(int aKey, short ... aShorts) {
        }

        public void set(int aKey, Short ... aShorts) {
        }

        public void set(int aKey, int ... aInts) {
        }

        public void set(int aKey, Integer ... aInts) {
        }

        public void set(int aKey, long ... aLongs) {
        }

        public void set(int aKey, Long ... aLongs) {
        }

        public void set(int aKey, float ... aFloats) {
        }

        public void set(int aKey, Float ... aFloats) {
        }

        public void set(int aKey, double ... aDoubles) {
        }

        public void set(int aKey, Double ... aDoubles) {
        }

        public void set(int aKey, String ... aStrings) {
        }

        public void set(int aKey, String[] aStrings, boolean aForceAsciiEncoding) {
        }

        public void set(int aKey, Msg ... aMsgs) {
        }

        public void setAll(Msg aMsg) {
        }

        public void setAll(Object ... aAnObjects) {
        }

        public void remove(int ... aKeys) {
        }

        public void removeAll() {
        }
    }
}

