/*
 * Decompiled with CFR 0.152.
 */
package com.github.hermod.ser;

import com.github.hermod.ser.Type;

public final class Null {
    private static final Null[] LENGTH_NULLS = new Null[30];
    public static final Null NULL = new Null(Type.NULL);
    public static final Null INTEGER_NULL = new Null(Type.INTEGER);
    public static final Null BYTE_NULL = new Null(Type.BYTE);
    public static final Null SHORT_NULL = new Null(Type.SHORT);
    public static final Null INT_NULL = new Null(Type.INT);
    public static final Null LONG_NULL = new Null(Type.LONG);
    public static final Null DECIMAL_NULL = new Null(Type.DECIMAL);
    public static final Null FLOAT_NULL = new Null(Type.FLOAT);
    public static final Null DOUBLE_NULL = new Null(Type.DOUBLE);
    public static final Null FIVE_BITS_DECIMAL_NULL = new Null(Type.FIVE_BITS_DECIMAL);
    public static final Null STRING_UTF8_NULL = new Null(Type.STRING_UTF8);
    public static final Null MSG_NULL = new Null(Type.MSG);
    public static final Null ARRAY_FIXED_VALUE_NULL = new Null(Type.ARRAY_FIXED_VALUE);
    public static final Null ARRAY_VARIABLE_VALUE_NULL = new Null(Type.ARRAY_VARIABLE_VALUE);
    private final int length;
    private final Type type;

    private Null(int aLength) {
        if (aLength < 0) {
            throw new IllegalArgumentException("The length must be superior to 0.");
        }
        this.type = Type.NULL;
        this.length = aLength;
    }

    private Null(Type aType) {
        this.type = aType;
        switch (aType) {
            case BYTE: {
                this.length = 1;
                break;
            }
            case SHORT: {
                this.length = 2;
                break;
            }
            case INT: {
                this.length = 4;
                break;
            }
            case LONG: {
                this.length = 8;
                break;
            }
            case FLOAT: {
                this.length = 4;
                break;
            }
            case DOUBLE: {
                this.length = 8;
                break;
            }
            case FIVE_BITS_DECIMAL: {
                this.length = 5;
                break;
            }
            default: {
                this.length = 0;
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    public Type getType() {
        return this.type;
    }

    public static Null valueOf(int aLength) {
        try {
            return LENGTH_NULLS[aLength];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new Null(aLength);
        }
    }

    public static Null valueOf(Type aType) {
        if (aType == null) {
            throw new IllegalArgumentException("The Type must not be null.");
        }
        switch (aType) {
            case SKIPPED_KEYS: {
                throw new IllegalArgumentException("This makes no sense to create a Null for type SKIPPED_KEYS_TYPE");
            }
            case INTEGER: {
                return INTEGER_NULL;
            }
            case BYTE: {
                return BYTE_NULL;
            }
            case SHORT: {
                return SHORT_NULL;
            }
            case INT: {
                return INT_NULL;
            }
            case LONG: {
                return LONG_NULL;
            }
            case DECIMAL: {
                return DECIMAL_NULL;
            }
            case FLOAT: {
                return FLOAT_NULL;
            }
            case DOUBLE: {
                return DOUBLE_NULL;
            }
            case FIVE_BITS_DECIMAL: {
                return FIVE_BITS_DECIMAL_NULL;
            }
            case STRING_UTF8: {
                return STRING_UTF8_NULL;
            }
            case MSG: {
                return MSG_NULL;
            }
            case ARRAY_FIXED_VALUE: {
                return ARRAY_FIXED_VALUE_NULL;
            }
            case ARRAY_VARIABLE_VALUE: {
                return ARRAY_VARIABLE_VALUE_NULL;
            }
        }
        return NULL;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Null other = (Null)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "Null [length=" + this.length + ", type=" + (Object)((Object)this.type) + ", toString()=" + super.toString() + "]";
    }

    static {
        Null.LENGTH_NULLS[0] = NULL;
        for (int i = 1; i < LENGTH_NULLS.length; ++i) {
            Null.LENGTH_NULLS[i] = new Null(i);
        }
    }
}

