/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain.core;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public class ShapeUtil {
    private ShapeUtil() {
    }

    public static double area(Shape a) {
        PathIterator i = a.getPathIterator(new AffineTransform(), 0.001);
        double x = 0.0;
        double y = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double area = 0.0;
        while (!i.isDone()) {
            double[] coords = new double[6];
            int type = i.currentSegment(coords);
            switch (type) {
                case 4: {
                    double nx = sx;
                    double ny = sy;
                    area += x * ny;
                    area -= y * nx;
                    break;
                }
                case 1: {
                    double nx = coords[0];
                    double ny = coords[1];
                    area += x * ny;
                    area -= y * nx;
                    x = nx;
                    y = ny;
                    break;
                }
                case 0: {
                    x = sx = coords[0];
                    y = sy = coords[1];
                    break;
                }
                default: {
                    throw new Error("Bad segment type from Flattening Path Iterator");
                }
            }
            i.next();
        }
        if ((area /= 2.0) < 0.0) {
            area *= -1.0;
        }
        return area;
    }

    public static double perimeter(Shape a) {
        PathIterator i = a.getPathIterator(new AffineTransform(), 0.001);
        double x = 0.0;
        double y = 0.0;
        double len = 0.0;
        while (!i.isDone()) {
            double[] coords = new double[6];
            int type = i.currentSegment(coords);
            if (type == 1) {
                double nx = coords[0];
                double ny = coords[1];
                len += Math.sqrt(Math.pow(x - nx, 2.0) + Math.pow(y - ny, 2.0));
                x = nx;
                y = ny;
            } else if (type == 0) {
                x = coords[0];
                y = coords[1];
            }
            i.next();
        }
        return len;
    }
}

