/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.pressure;

import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.infra.FormulaConfiguration;
import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.github.jbgust.jsrm.infra.function.CircleAreaFunction;
import com.github.jbgust.jsrm.infra.function.HollowCircleAreaFunction;
import com.github.jbgust.jsrm.infra.pressure.function.BurnRateCharacteristicFunction;
import com.github.jbgust.jsrm.infra.pressure.function.ErosiveBurnFactorFunction;
import com.github.jbgust.jsrm.infra.pressure.function.FreeVolumeInChamberFunction;
import com.github.jbgust.jsrm.infra.pressure.function.GrainMassFunction;
import com.github.jbgust.jsrm.infra.pressure.function.LowKnFunction;
import com.github.jbgust.jsrm.infra.pressure.function.NozzleMassFlowRateFunction;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public enum PressureFormulas implements Formula
{
    WEB_THICKNESS(new FormulaConfiguration("(GRAIN_OUTSIDE_DIAMETER - GRAIN_CORE_DIAMETER) / 2").withDependencies("GRAIN_CORE_DIAMETER", "GRAIN_OUTSIDE_DIAMETER")),
    THROAT_AREA(new FormulaConfiguration("CircleArea(dto+erate*progression)").withConstants(JSRMConstant.dto, JSRMConstant.erate).withVariables("progression").withFunctions(Functions.access$000())),
    NOZZLE_CRITICAL_PASSAGE_AREA(new FormulaConfiguration("THROAT_AREA / 1000^2").withDependencies("THROAT_AREA")),
    EROSIVE_BURN_FACTOR(new FormulaConfiguration("ErosiveBurnFactor((CircleArea(dc)-endGrainSurface)/THROAT_AREA, gstar)").withDependencies("THROAT_AREA").withVariables("endGrainSurface").withConstants(JSRMConstant.dc, JSRMConstant.gstar).withFunctions(Functions.access$100(), Functions.access$000())),
    TEMPORARY_CHAMBER_PRESSURE(new FormulaConfiguration("CHAMBER_PRESSURE_MPA_previous").withVariables("CHAMBER_PRESSURE_MPA_previous")),
    PROPELLANT_BURN_RATE(new FormulaConfiguration("(1 + kv * EROSIVE_BURN_FACTOR) * BurnRateCharacteristic(propellantId, TEMPORARY_CHAMBER_PRESSURE)").withConstants(JSRMConstant.kv, JSRMConstant.propellantId).withFunctions(Functions.access$200()).withDependencies("EROSIVE_BURN_FACTOR", "TEMPORARY_CHAMBER_PRESSURE")),
    TIME_SINCE_BURN_STARTS(new FormulaConfiguration("xincp / PROPELLANT_BURN_RATE + TIME_SINCE_BURN_STARTS_previous").withConstants(JSRMConstant.xincp).withDependencies("PROPELLANT_BURN_RATE").withVariables("TIME_SINCE_BURN_STARTS_previous")),
    MASS_GENERATION_RATE(new FormulaConfiguration("(GrainMass(rhopgrain, grainVolume_previous)-GrainMass(rhopgrain, grainVolume)) / (TIME_SINCE_BURN_STARTS-TIME_SINCE_BURN_STARTS_previous)").withDependencies("TIME_SINCE_BURN_STARTS").withVariables("grainVolume_previous", "TIME_SINCE_BURN_STARTS_previous", "grainVolume").withConstants(JSRMConstant.rhopgrain).withFunctions(Functions.access$300())),
    NOZZLE_MASS_FLOW_RATE(new FormulaConfiguration("NozzleMassFlowRate(pbd, MASS_GENERATION_RATE, CHAMBER_PRESSURE_MPA_previous, AI)").withConstants(JSRMConstant.pbd).withDependencies("MASS_GENERATION_RATE", "AI").withVariables("CHAMBER_PRESSURE_MPA_previous").withFunctions(Functions.access$400())),
    MASS_STORAGE_RATE(new FormulaConfiguration("lowKn(MASS_GENERATION_RATE - NOZZLE_MASS_FLOW_RATE, safeKN)").withDependencies("MASS_GENERATION_RATE", "NOZZLE_MASS_FLOW_RATE").withConstants(JSRMConstant.safeKN).withFunctions(Functions.access$500())),
    MASS_COMBUSTION_PRODUCTS(new FormulaConfiguration("MASS_STORAGE_RATE * (TIME_SINCE_BURN_STARTS-TIME_SINCE_BURN_STARTS_previous) + MASS_COMBUSTION_PRODUCTS_previous").withVariables("TIME_SINCE_BURN_STARTS_previous", "MASS_COMBUSTION_PRODUCTS_previous").withDependencies("MASS_STORAGE_RATE", "TIME_SINCE_BURN_STARTS")),
    DENSITY_COMBUSTION_PRODUCTS(new FormulaConfiguration("MASS_COMBUSTION_PRODUCTS / FreeVolumeInChamber(vc, grainVolume)").withDependencies("MASS_COMBUSTION_PRODUCTS").withVariables("grainVolume").withConstants(JSRMConstant.vc).withFunctions(Functions.access$600())),
    CHAMBER_PRESSURE_MPA(new FormulaConfiguration("(DENSITY_COMBUSTION_PRODUCTS * rat * to + patm * 1000000) / 1000000").withDependencies("DENSITY_COMBUSTION_PRODUCTS").withConstants(JSRMConstant.rat, JSRMConstant.to, JSRMConstant.patm)),
    ABSOLUTE_CHAMBER_PRESSURE(new FormulaConfiguration("CHAMBER_PRESSURE_MPA - patm").withDependencies("CHAMBER_PRESSURE_MPA").withConstants(JSRMConstant.patm)),
    ABSOLUTE_CHAMBER_PRESSURE_PSIG(new FormulaConfiguration("ABSOLUTE_CHAMBER_PRESSURE * 1000000 / 6895").withDependencies("ABSOLUTE_CHAMBER_PRESSURE")),
    AI(new FormulaConfiguration("(TEMPORARY_CHAMBER_PRESSURE - patm) * 1000000 * NOZZLE_CRITICAL_PASSAGE_AREA / sqrt(rat*to) * sqrt(k) * (2/(k+1))^((k+1)/2/(k-1))").withDependencies("TEMPORARY_CHAMBER_PRESSURE", "NOZZLE_CRITICAL_PASSAGE_AREA").withConstants(JSRMConstant.patm, JSRMConstant.rat, JSRMConstant.to, JSRMConstant.k)),
    KN(new FormulaConfiguration("burningSurface / throatArea").withVariables("throatArea", "burningSurface"));

    private final Expression expression;
    private final Set<String> dependencies;
    private final String expressionAsString;

    private PressureFormulas(FormulaConfiguration config) {
        this.expressionAsString = config.getFormula();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.expressionAsString);
        this.dependencies = Stream.of(config.getDependencies()).peek(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0)).collect(Collectors.toSet());
        expressionBuilder.functions(config.getFunctions());
        Stream.of(config.getConstants()).map(Enum::toString).forEach(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0));
        Stream.of(config.getVariables()).forEach(arg_0 -> ((ExpressionBuilder)expressionBuilder).variable(arg_0));
        this.expression = expressionBuilder.build();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getExpressionAsString() {
        return this.expressionAsString;
    }

    @Override
    public Set<Formula> getDependencies() {
        return this.dependencies.stream().map(PressureFormulas::valueOf).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getVariablesNames() {
        return this.expression.getVariableNames();
    }

    private static class Functions {
        private static final CircleAreaFunction circleArea = new CircleAreaFunction();
        private static final ErosiveBurnFactorFunction erosiveBurnFactor = new ErosiveBurnFactorFunction();
        private static final HollowCircleAreaFunction hollowCircleArea = new HollowCircleAreaFunction();
        private static final BurnRateCharacteristicFunction burnRateCharacteristic = new BurnRateCharacteristicFunction();
        private static final GrainMassFunction grainMass = new GrainMassFunction();
        private static final NozzleMassFlowRateFunction nozzleMassFlowRate = new NozzleMassFlowRateFunction();
        private static final FreeVolumeInChamberFunction freeVolumeInChamber = new FreeVolumeInChamberFunction();
        private static final LowKnFunction lowKNFunction = new LowKnFunction();

        private Functions() {
        }

        static /* synthetic */ CircleAreaFunction access$000() {
            return circleArea;
        }

        static /* synthetic */ ErosiveBurnFactorFunction access$100() {
            return erosiveBurnFactor;
        }

        static /* synthetic */ BurnRateCharacteristicFunction access$200() {
            return burnRateCharacteristic;
        }

        static /* synthetic */ GrainMassFunction access$300() {
            return grainMass;
        }

        static /* synthetic */ NozzleMassFlowRateFunction access$400() {
            return nozzleMassFlowRate;
        }

        static /* synthetic */ LowKnFunction access$500() {
            return lowKNFunction;
        }

        static /* synthetic */ FreeVolumeInChamberFunction access$600() {
            return freeVolumeInChamber;
        }
    }
}

