/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.CommandSettings;
import com.github.johnnyjayjay.discord.commandapi.ICommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.IMentionable;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;

public class CommandEvent
extends GuildMessageReceivedEvent {
    private final Command command;
    private final CommandSettings settings;

    public CommandEvent(JDA api, long responseNumber, Message message, Command command, CommandSettings settings) {
        super(api, responseNumber, message);
        this.command = command;
        this.settings = settings;
    }

    public void respond(String msg) {
        if (this.checkBotPermissions(Permission.MESSAGE_WRITE, Permission.MESSAGE_EMBED_LINKS)) {
            this.getChannel().sendMessage((CharSequence)msg).queue();
        }
    }

    public void respond(MessageEmbed msg) {
        if (this.checkBotPermissions(Permission.MESSAGE_WRITE, Permission.MESSAGE_EMBED_LINKS)) {
            this.getChannel().sendMessage(msg).queue();
        }
    }

    public void respond(Message msg) {
        if (this.checkBotPermissions(Permission.MESSAGE_WRITE, Permission.MESSAGE_EMBED_LINKS)) {
            this.getChannel().sendMessage(msg).queue();
        }
    }

    public Command getCommand() {
        return this.command;
    }

    public CommandSettings getCommandSettings() {
        return this.settings;
    }

    public String[] getArgs() {
        return this.command.args;
    }

    public Optional<? extends IMentionable> getFirstMention(Message.MentionType ... mentionTypes) {
        List mentions = this.getMessage().getMentions(mentionTypes);
        Optional<Object> ret = mentions.isEmpty() ? Optional.empty() : Optional.of((IMentionable)mentions.get(0));
        return ret;
    }

    public Optional<User> getFirstUserMention() {
        return this.getFirstMention(Message.MentionType.USER);
    }

    public Optional<Role> getFirstRoleMention() {
        return this.getFirstMention(Message.MentionType.ROLE);
    }

    public Optional<TextChannel> getFirstChannelMention() {
        return this.getFirstMention(Message.MentionType.CHANNEL);
    }

    public boolean checkMemberPermissions(Permission ... permissions) {
        return this.getMember().hasPermission((Channel)this.channel, permissions);
    }

    public boolean checkBotPermissions(Permission ... permissions) {
        return this.guild.getSelfMember().hasPermission((Channel)this.channel, permissions);
    }

    protected static Command parseCommand(String raw, String prefix, CommandSettings settings) {
        return new Command(raw, prefix, settings);
    }

    public static class Command {
        private final ICommand command;
        private final String joinedArgs;
        private final String rawArgs;
        private final String rawMessage;
        private final String label;
        private final String[] args;

        private Command(String raw, String prefix, CommandSettings settings) {
            String[] argsWithoutPrefix = raw.replaceFirst(prefix, "").split("\\s+");
            String string = this.label = settings.isLabelIgnoreCase() ? argsWithoutPrefix[0].toLowerCase() : argsWithoutPrefix[0];
            if (!settings.getCommands().containsKey(this.label)) {
                this.command = null;
                this.joinedArgs = null;
                this.rawMessage = null;
                this.rawArgs = null;
                this.args = null;
            } else {
                this.command = settings.getCommands().get(this.label);
                this.rawMessage = raw;
                this.args = Arrays.copyOfRange(argsWithoutPrefix, 1, argsWithoutPrefix.length);
                this.joinedArgs = String.join((CharSequence)" ", this.args);
                this.rawArgs = raw.replaceFirst(prefix + this.label + "\\s+", "");
            }
        }

        public String getLabel() {
            return this.label;
        }

        public String[] getArgs() {
            return this.args;
        }

        public ICommand getExecutor() {
            return this.command;
        }

        public String getRawMessage() {
            return this.rawMessage;
        }

        public String getRawArgs() {
            return this.rawArgs;
        }

        public List<String> getArgsAsList() {
            return Collections.unmodifiableList(Arrays.asList(this.args));
        }

        public String getJoinedArgs() {
            return this.joinedArgs;
        }

        @Deprecated
        public String getJoinedArgs(int fromIndex) {
            if (fromIndex >= this.args.length || fromIndex < 0) {
                throw new IllegalArgumentException("invalid index! The arguments array only has a total length of " + this.args.length);
            }
            return String.join((CharSequence)" ", Arrays.asList(this.args).subList(fromIndex, this.args.length));
        }

        public String joinArgs(int fromIndex) {
            return this.joinArgs(fromIndex, this.args.length);
        }

        public String joinArgs(int fromIndex, int toIndex) {
            return this.joinArgs(" ", fromIndex, toIndex);
        }

        public String joinArgs(@Nonnull CharSequence delimiter, int fromIndex, int toIndex) {
            if (fromIndex >= this.args.length || fromIndex < 0 || toIndex < fromIndex || toIndex > this.args.length) {
                throw new IllegalArgumentException("Invalid index! The indexes are either out of bounds or toIndex is smaller than fromIndex.");
            }
            return String.join(delimiter, Arrays.copyOfRange(this.args, fromIndex, toIndex));
        }
    }
}

