/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.CommandEvent;
import com.github.johnnyjayjay.discord.commandapi.CommandSettings;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.core.hooks.ListenerAdapter;

class CommandListener
extends ListenerAdapter {
    private CommandSettings settings;
    private Map<Long, Long> cooldowns;

    public CommandListener(CommandSettings settings) {
        this.settings = settings;
        this.cooldowns = new HashMap<Long, Long>();
    }

    public void onGuildMessageReceived(GuildMessageReceivedEvent event) {
        String prefix;
        String raw;
        TextChannel channel = event.getChannel();
        if (!this.settings.getBlacklistedChannels().contains(channel.getIdLong()) && (!event.getAuthor().isBot() || this.settings.botsMayExecute()) && (raw = event.getMessage().getContentRaw()).startsWith(prefix = this.settings.getPrefix(event.getGuild().getIdLong()))) {
            long timestamp = System.currentTimeMillis();
            long userId = event.getAuthor().getIdLong();
            if (this.cooldowns.containsKey(userId) && timestamp - this.cooldowns.get(userId) < this.settings.getCooldown()) {
                if (this.settings.isResetCooldown()) {
                    this.cooldowns.put(userId, timestamp);
                }
                return;
            }
            this.cooldowns.put(userId, timestamp);
            CommandEvent.Command cmd = CommandEvent.parseCommand(raw, prefix, this.settings);
            if (cmd.getExecutor() != null) {
                try {
                    cmd.getExecutor().onCommand(new CommandEvent(event.getJDA(), event.getResponseNumber(), event.getMessage(), cmd, this.settings), event.getMember(), channel, cmd.getArgs());
                }
                catch (Throwable t) {
                    CommandSettings.LOGGER.warn("One of the commands had an uncaught exception:", t);
                }
            } else {
                Message unknownCommand = this.settings.getUnknownCommandMessage();
                if (unknownCommand != null && event.getGuild().getSelfMember().hasPermission((Channel)channel, new Permission[]{Permission.MESSAGE_WRITE, Permission.MESSAGE_EMBED_LINKS})) {
                    channel.sendMessage(unknownCommand).queue();
                }
            }
        }
    }
}

