/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.longdt.vertxorm.repository.PageRequest;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

@DataObject
public class Page<E> {
    private int currentPage;
    private int pageSize;
    private long totalPage;
    private long totalElements;
    private List<E> content;

    Page(int currentPage, int pageSize, long totalPage, long totalElements, List<E> content) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.totalPage = totalPage;
        this.totalElements = totalElements;
        this.content = content;
    }

    public Page(PageRequest pageRequest, long totalElements, List<E> content) {
        this(pageRequest.getIndex(), pageRequest.getSize(), totalElements, content);
    }

    public Page(int currentPage, int pageSize, long totalElements, List<E> content) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.totalPage = (totalElements + (long)(pageSize - 1)) / (long)pageSize;
        this.totalElements = totalElements;
        this.content = content;
    }

    public Page(JsonObject jsonObject) {
        try {
            DatabindCodec.mapper().updateValue((Object)this, (Object)jsonObject);
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
    }

    public JsonObject toJson() {
        return JsonObject.mapFrom((Object)this);
    }

    public <R> Page<R> map(Function<E, R> mapFn) {
        ArrayList result = new ArrayList(this.content.size());
        this.content.forEach(e -> result.add(mapFn.apply(e)));
        return new Page(this.currentPage, this.pageSize, this.totalPage, this.totalElements, result);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public List<E> getContent() {
        return this.content;
    }
}

