/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.postgresql;

import com.github.longdt.vertxorm.repository.Configuration;
import com.github.longdt.vertxorm.repository.CrudRepository;
import com.github.longdt.vertxorm.repository.EntityNotFoundException;
import com.github.longdt.vertxorm.repository.IdAccessor;
import com.github.longdt.vertxorm.repository.Page;
import com.github.longdt.vertxorm.repository.PageRequest;
import com.github.longdt.vertxorm.repository.SqlSupport;
import com.github.longdt.vertxorm.repository.postgresql.SqlSupportImpl;
import com.github.longdt.vertxorm.repository.query.Query;
import com.github.longdt.vertxorm.util.Tuples;
import io.vertx.core.Future;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public abstract class AbstractCrudRepository<ID, E>
implements CrudRepository<ID, E> {
    protected Pool pool;
    private IdAccessor<ID, E> idAccessor;
    protected Function<Row, E> rowMapper;
    protected Function<E, Object[]> parametersMapper;
    protected Collector<Row, ?, List<E>> collector;
    protected SqlSupport sqlSupport;

    public void init(Pool pool, Configuration<ID, E> configuration) {
        this.pool = pool;
        this.rowMapper = Objects.requireNonNull(configuration.getRowMapper());
        this.collector = Collectors.mapping(this.rowMapper, Collectors.toList());
        this.parametersMapper = Objects.requireNonNull(configuration.getParametersMapper());
        this.idAccessor = Objects.requireNonNull(configuration.getIdAccessor());
        this.sqlSupport = new SqlSupportImpl(configuration.getTableName(), configuration.getColumnNames());
    }

    @Override
    public Future<E> save(SqlConnection conn, E entity) {
        if (this.idAccessor.getId(entity) == null) {
            return this.insert(conn, entity);
        }
        return this.upsert(conn, entity);
    }

    @Override
    public Future<E> insert(SqlConnection conn, E entity) {
        Tuple paramsTuple;
        String sql;
        boolean genPk = this.idAccessor.getId(entity) == null;
        Object[] params = this.parametersMapper.apply(entity);
        if (genPk) {
            sql = this.sqlSupport.getAutoIdInsertSql();
            paramsTuple = Tuples.shift(params, 1);
        } else {
            sql = this.sqlSupport.getInsertSql();
            paramsTuple = Tuple.wrap((Object[])params);
        }
        return conn.preparedQuery(sql).execute(paramsTuple).map(res -> {
            try {
                if (genPk) {
                    this.idAccessor.setId(entity, this.idAccessor.db2IdValue(((Row)res.iterator().next()).getValue(0)));
                }
                return entity;
            }
            catch (Exception e) {
                throw new RuntimeException("Can't set id value of entity: " + entity.getClass().getName(), e);
            }
        });
    }

    @Override
    public Future<E> update(SqlConnection conn, E entity) {
        Object[] params = this.parametersMapper.apply(entity);
        return conn.preparedQuery(this.sqlSupport.getUpdateSql()).execute(Tuple.wrap((Object[])params)).map(entity);
    }

    private Future<E> upsert(SqlConnection conn, E entity) {
        Object[] params = this.parametersMapper.apply(entity);
        return conn.preparedQuery(this.sqlSupport.getUpsertSql()).execute(Tuple.wrap((Object[])params)).map(entity);
    }

    @Override
    public Future<Void> delete(SqlConnection conn, ID id) {
        return conn.preparedQuery(this.sqlSupport.getDeleteSql()).execute(Tuple.of((Object)this.idAccessor.id2DbValue(id))).map(res -> {
            if (res.rowCount() != 1) {
                throw new EntityNotFoundException("Entity " + id + " is not found");
            }
            return null;
        });
    }

    @Override
    public Future<Optional<E>> find(SqlConnection conn, ID id) {
        return conn.preparedQuery(this.sqlSupport.getQueryByIdSql()).mapping(this.rowMapper).execute(Tuple.of((Object)this.idAccessor.id2DbValue(id))).map(this::toEntity);
    }

    protected List<E> toList(SqlResult<List<E>> sqlResult) {
        return (List)sqlResult.value();
    }

    protected Optional<E> toEntity(RowSet<E> rowSet) {
        RowIterator rowIter = rowSet.iterator();
        Object entity = rowIter.hasNext() ? rowIter.next() : null;
        return Optional.ofNullable(entity);
    }

    @Override
    public Future<List<E>> findAll(SqlConnection conn) {
        return conn.query(this.sqlSupport.getQuerySql()).collecting(this.collector).execute().map(this::toList);
    }

    @Override
    public Future<List<E>> findAll(SqlConnection conn, Query<E> query) {
        String sql = this.sqlSupport.getSql(this.sqlSupport.getQuerySql(), query);
        Tuple params = this.getSqlParams(query);
        return conn.preparedQuery(sql).collecting(this.collector).execute(params).map(this::toList);
    }

    @Override
    public Future<Optional<E>> find(SqlConnection conn, Query<E> query) {
        String sql = this.sqlSupport.getSql(this.sqlSupport.getQuerySql(), query);
        Tuple params = this.getSqlParams(query);
        return conn.preparedQuery(sql).mapping(this.rowMapper).execute(params).map(this::toEntity);
    }

    @Override
    public Future<Page<E>> findAll(SqlConnection conn, Query<E> query, PageRequest pageRequest) {
        query.limit(pageRequest.getSize()).offset(pageRequest.getOffset());
        String sql = this.sqlSupport.getSql(this.sqlSupport.getQuerySql(), query);
        Tuple params = this.getSqlParams(query);
        return conn.preparedQuery(sql).collecting(this.collector).execute(params).compose(sqlResult -> {
            List content = (List)sqlResult.value();
            if (content.size() < pageRequest.getSize()) {
                return Future.succeededFuture(new Page(pageRequest, pageRequest.getOffset() + (long)content.size(), content));
            }
            return this.count(conn, query).map(cnt -> new Page(pageRequest, (long)cnt, content));
        });
    }

    @Override
    public Future<Long> count(SqlConnection conn, Query<E> query) {
        return conn.preparedQuery(this.sqlSupport.getQuerySql(this.sqlSupport.getCountSql(), query)).execute(query.getQueryParams()).map(res -> ((Row)res.iterator().next()).getLong(0));
    }

    @Override
    public Future<Boolean> exists(SqlConnection conn, ID id) {
        return conn.preparedQuery(this.sqlSupport.getExistByIdSql()).execute(Tuple.of((Object)this.idAccessor.id2DbValue(id))).map(res -> res.size() > 0);
    }

    @Override
    public Future<Boolean> exists(SqlConnection conn, Query<E> query) {
        query.limit(1).offset(-1L);
        String sql = this.sqlSupport.getSql(this.sqlSupport.getExistSql(), query);
        Tuple params = this.getSqlParams(query);
        return conn.preparedQuery(sql).execute(params).map(res -> res.size() > 0);
    }

    protected Tuple getSqlParams(Query<E> query) {
        if (query.limit() < 0 && query.offset() < 0L) {
            return query.getQueryParams();
        }
        Tuple params = Tuple.tuple();
        params = query.appendQueryParams(params);
        if (query.limit() >= 0) {
            params.addInteger(Integer.valueOf(query.limit()));
        }
        if (query.offset() >= 0L) {
            params.addLong(Long.valueOf(query.offset()));
        }
        return params;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }
}

