/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain;

import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.co.mruoc.cronparser.domain.CronResult;

public class CronResultFormatter {
    public String format(CronResult result) {
        return CronResultFormatter.toLines(result).collect(Collectors.joining(System.lineSeparator()));
    }

    public static Stream<String> toLines(CronResult result) {
        return Stream.of(CronResultFormatter.formatMinutes(result), CronResultFormatter.formatHours(result), CronResultFormatter.formatDaysOfMonth(result), CronResultFormatter.formatMonths(result), CronResultFormatter.formatDaysOfWeek(result), CronResultFormatter.formatCommand(result));
    }

    private static String formatMinutes(CronResult result) {
        return CronResultFormatter.formatValues("minute", result::getMinutes);
    }

    private static String formatHours(CronResult result) {
        return CronResultFormatter.formatValues("hour", result::getHours);
    }

    private static String formatDaysOfMonth(CronResult result) {
        return CronResultFormatter.formatValues("day of month", result::getDaysOfMonth);
    }

    private static String formatMonths(CronResult result) {
        return CronResultFormatter.formatValues("month", result::getMonths);
    }

    private static String formatDaysOfWeek(CronResult result) {
        return CronResultFormatter.formatValues("day of week", result::getDaysOfWeek);
    }

    private static String formatCommand(CronResult result) {
        return CronResultFormatter.formatValues("command", result.getCommand());
    }

    private static String formatValues(String name, Supplier<int[]> values) {
        return CronResultFormatter.formatValues(name, CronResultFormatter.toString(values.get()));
    }

    private static String formatValues(String name, String values) {
        return String.format("%-14s%s", name, values);
    }

    private static String toString(int[] values) {
        return Arrays.stream(values).sorted().mapToObj(Integer::toString).collect(Collectors.joining(" "));
    }
}

