/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain;

import lombok.Generated;
import uk.co.mruoc.cronparser.domain.ArgumentsSanitizer;
import uk.co.mruoc.cronparser.domain.CronExpressionParser;
import uk.co.mruoc.cronparser.domain.CronResult;
import uk.co.mruoc.cronparser.domain.CronResultFormatter;
import uk.co.mruoc.cronparser.domain.ParserException;
import uk.co.mruoc.cronparser.domain.SystemWriter;
import uk.co.mruoc.cronparser.domain.Writer;

public class App {
    private final ArgumentsSanitizer sanitizer;
    private final CronExpressionParser parser;
    private final CronResultFormatter formatter;
    private final Writer writer;

    public void run(String[] args) {
        try {
            String[] sanitizedArgs = this.sanitizer.sanitize(args);
            CronResult result = this.parser.parse(sanitizedArgs);
            this.print(result);
        }
        catch (ParserException e) {
            this.printErrorMessage(e);
        }
    }

    private void print(CronResult result) {
        this.writer.writeOutput(this.formatter.format(result));
    }

    private void printErrorMessage(Throwable e) {
        this.writer.writeError(e.getMessage());
    }

    @Generated
    private static ArgumentsSanitizer $default$sanitizer() {
        return new ArgumentsSanitizer();
    }

    @Generated
    private static CronExpressionParser $default$parser() {
        return new CronExpressionParser();
    }

    @Generated
    private static CronResultFormatter $default$formatter() {
        return new CronResultFormatter();
    }

    @Generated
    private static Writer $default$writer() {
        return new SystemWriter();
    }

    @Generated
    App(ArgumentsSanitizer sanitizer, CronExpressionParser parser, CronResultFormatter formatter, Writer writer) {
        this.sanitizer = sanitizer;
        this.parser = parser;
        this.formatter = formatter;
        this.writer = writer;
    }

    @Generated
    public static AppBuilder builder() {
        return new AppBuilder();
    }

    @Generated
    public static class AppBuilder {
        @Generated
        private boolean sanitizer$set;
        @Generated
        private ArgumentsSanitizer sanitizer$value;
        @Generated
        private boolean parser$set;
        @Generated
        private CronExpressionParser parser$value;
        @Generated
        private boolean formatter$set;
        @Generated
        private CronResultFormatter formatter$value;
        @Generated
        private boolean writer$set;
        @Generated
        private Writer writer$value;

        @Generated
        AppBuilder() {
        }

        @Generated
        public AppBuilder sanitizer(ArgumentsSanitizer sanitizer) {
            this.sanitizer$value = sanitizer;
            this.sanitizer$set = true;
            return this;
        }

        @Generated
        public AppBuilder parser(CronExpressionParser parser) {
            this.parser$value = parser;
            this.parser$set = true;
            return this;
        }

        @Generated
        public AppBuilder formatter(CronResultFormatter formatter) {
            this.formatter$value = formatter;
            this.formatter$set = true;
            return this;
        }

        @Generated
        public AppBuilder writer(Writer writer) {
            this.writer$value = writer;
            this.writer$set = true;
            return this;
        }

        @Generated
        public App build() {
            ArgumentsSanitizer sanitizer$value = this.sanitizer$value;
            if (!this.sanitizer$set) {
                sanitizer$value = App.$default$sanitizer();
            }
            CronExpressionParser parser$value = this.parser$value;
            if (!this.parser$set) {
                parser$value = App.$default$parser();
            }
            CronResultFormatter formatter$value = this.formatter$value;
            if (!this.formatter$set) {
                formatter$value = App.$default$formatter();
            }
            Writer writer$value = this.writer$value;
            if (!this.writer$set) {
                writer$value = App.$default$writer();
            }
            return new App(sanitizer$value, parser$value, formatter$value, writer$value);
        }

        @Generated
        public String toString() {
            return "App.AppBuilder(sanitizer$value=" + this.sanitizer$value + ", parser$value=" + this.parser$value + ", formatter$value=" + this.formatter$value + ", writer$value=" + this.writer$value + ")";
        }
    }
}

