/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.client.ClientConfig;
import com.mpush.util.thread.EventLock;
import java.util.concurrent.Callable;

public class ConnectThread
extends Thread {
    private volatile Callable<Boolean> runningTask;
    private volatile boolean runningFlag = true;
    private final EventLock connLock;

    public ConnectThread(EventLock connLock) {
        this.connLock = connLock;
        this.setName("mp-client-start-t");
        this.start();
    }

    public synchronized void addConnectTask(Callable<Boolean> task) {
        Callable<Boolean> oldTask = this.runningTask;
        if (oldTask != null) {
            this.interrupt();
        }
        this.runningTask = task;
        this.notify();
    }

    public synchronized void shutdown() {
        this.runningFlag = false;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.runningFlag) {
            try {
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    while (this.runningTask == null) {
                        this.wait();
                    }
                }
                if (!this.runningTask.call().booleanValue()) continue;
                break;
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                ClientConfig.I.getLogger().e(e, "run connect task error", new Object[0]);
                break;
            }
        }
    }
}

