/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.http;

import com.mpush.api.Constants;
import com.mpush.api.http.HttpCallback;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public final class HttpRequest {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded; charset=";
    public final byte method;
    public final String uri;
    private Map<String, String> headers = new HashMap<String, String>();
    private byte[] body;
    private HttpCallback callback;
    private int timeout;

    public HttpRequest(byte method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public static HttpRequest buildGet(String uri) {
        return new HttpRequest(0, uri);
    }

    public static HttpRequest buildPost(String uri) {
        return new HttpRequest(1, uri);
    }

    public static HttpRequest buildPut(String uri) {
        return new HttpRequest(2, uri);
    }

    public static HttpRequest buildDelete(String uri) {
        return new HttpRequest(3, uri);
    }

    public static HttpRequest build(byte method, String uri) {
        return new HttpRequest(method, uri);
    }

    public byte getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, String> getHeaders() {
        this.headers.put("readTimeout", Integer.toString(this.timeout));
        return this.headers;
    }

    public HttpRequest setHeaders(Map<String, String> headers) {
        this.getHeaders().putAll(headers);
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpRequest setBody(byte[] body, String contentType) {
        this.body = body;
        this.headers.put(CONTENT_TYPE, contentType);
        return this;
    }

    public HttpRequest setPostParam(Map<String, String> headers, Charset paramsEncoding) {
        byte[] bytes = this.encodeParameters(headers, paramsEncoding.name());
        this.setBody(bytes, CONTENT_TYPE_FORM + paramsEncoding.name());
        return this;
    }

    public HttpRequest setPostParam(Map<String, String> headers) {
        this.setPostParam(headers, Constants.UTF_8);
        return this;
    }

    public HttpCallback getCallback() {
        return this.callback;
    }

    public HttpRequest setCallback(HttpCallback callback) {
        this.callback = callback;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public HttpRequest setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    private byte[] encodeParameters(Map<String, String> params, String paramsEncoding) {
        StringBuilder encodedParams = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                encodedParams.append(URLEncoder.encode(entry.getKey(), paramsEncoding));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), paramsEncoding));
                encodedParams.append('&');
            }
            return encodedParams.toString().getBytes(paramsEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + paramsEncoding, uee);
        }
    }

    public String toString() {
        return "HttpRequest{uri='" + this.uri + '\'' + ", method=" + this.method + ", timeout=" + this.timeout + '}';
    }
}

